/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.change;

import com.google.common.collect.Lists;
import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.block.BlockChangeSet;
import hellfirepvp.observerlib.common.api.MatcherObserverHelper;
import hellfirepvp.observerlib.common.change.BlockStateChangeSet;
import hellfirepvp.observerlib.common.util.NBTHelper;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MatchChangeSubscriber<T extends ChangeObserver>
implements ChangeSubscriber<T> {
    private BlockPos center;
    private T matcher;
    private BlockStateChangeSet changeSet = new BlockStateChangeSet();
    private Boolean isMatching = null;
    private Collection<ChunkPos> affectedChunkCache = null;

    public MatchChangeSubscriber(BlockPos center, T matcher) {
        this.center = center;
        this.matcher = matcher;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    @Nonnull
    public BlockChangeSet getCurrentChangeSet() {
        return this.changeSet;
    }

    @Override
    @Nonnull
    public T getObserver() {
        return this.matcher;
    }

    public Collection<ChunkPos> getObservableChunks() {
        if (this.affectedChunkCache == null) {
            this.affectedChunkCache = Lists.newArrayList(((ChangeObserver)this.getObserver()).getObservableArea().getAffectedChunks((Vec3i)this.getCenter()));
        }
        return this.affectedChunkCache;
    }

    public boolean observes(BlockPos pos) {
        return ((ChangeObserver)this.getObserver()).getObservableArea().observes((Vec3i)pos.func_177973_b((Vec3i)this.getCenter()));
    }

    public void addChange(BlockPos pos, BlockState oldState, BlockState newState) {
        this.changeSet.addChange(pos.func_177973_b((Vec3i)this.getCenter()), pos, oldState, newState);
    }

    @Override
    public boolean isValid(IWorld world) {
        if (this.isMatching != null && this.changeSet.isEmpty()) {
            return this.isMatching;
        }
        this.isMatching = ((ChangeObserver)this.matcher).notifyChange(world, this.getCenter(), this.changeSet);
        this.changeSet.reset();
        if (world instanceof World) {
            MatcherObserverHelper.getBuffer(world).markDirty((Vec3i)this.getCenter());
        }
        return this.isMatching;
    }

    public void readFromNBT(CompoundNBT tag) {
        this.affectedChunkCache = null;
        ((ChangeObserver)this.matcher).readFromNBT(tag.func_74775_l("matchData"));
        this.changeSet.readFromNBT(tag.func_74775_l("changeData"));
        this.center = NBTHelper.readBlockPosFromNBT(tag);
        this.isMatching = tag.func_74764_b("isMatching") ? Boolean.valueOf(tag.func_74767_n("isMatching")) : null;
    }

    public void writeToNBT(CompoundNBT tag) {
        NBTHelper.setAsSubTag(tag, "matchData", arg_0 -> this.matcher.writeToNBT(arg_0));
        NBTHelper.setAsSubTag(tag, "changeData", this.changeSet::writeToNBT);
        NBTHelper.writeBlockPosToNBT(this.center, tag);
        if (this.isMatching != null) {
            tag.func_74757_a("isMatching", this.isMatching.booleanValue());
        }
    }
}

