/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.WorldCacheIOThread;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class WorldCacheManager
implements ITickHandler {
    private static final String DEFAULT_DOMAIN_NAME = "worlddata";
    private static WorldCacheManager instance = new WorldCacheManager();
    private static Map<ResourceLocation, WorldCacheDomain> domains = new HashMap<ResourceLocation, WorldCacheDomain>();

    private WorldCacheManager() {
    }

    public static WorldCacheManager getInstance() {
        return instance;
    }

    public static void scheduleSaveAll() {
        for (WorldCacheDomain domain : domains.values()) {
            for (int dimId : domain.getUsedWorlds()) {
                for (WorldCacheDomain.SaveKey<? extends CachedWorldData> key : domain.getKnownSaveKeys()) {
                    CachedWorldData data = domain.getCachedData(dimId, key);
                    if (data == null || !data.needsSaving()) continue;
                    WorldCacheIOThread.scheduleSave(domain, dimId, data);
                }
            }
        }
    }

    public static void cleanUp() {
        for (WorldCacheDomain domain : domains.values()) {
            domain.clear();
        }
    }

    @Nonnull
    public static WorldCacheDomain createDomain(String modid) {
        ResourceLocation domainKey = new ResourceLocation(modid, DEFAULT_DOMAIN_NAME);
        WorldCacheDomain domain = new WorldCacheDomain(domainKey);
        domains.put(domainKey, domain);
        return domain;
    }

    @Nullable
    public static WorldCacheDomain findDomain(String modid) {
        ResourceLocation domainKey = new ResourceLocation(modid, DEFAULT_DOMAIN_NAME);
        for (ResourceLocation key : domains.keySet()) {
            if (!key.equals((Object)domainKey)) continue;
            return domains.get(key);
        }
        return null;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.field_72995_K) {
            return;
        }
        for (WorldCacheDomain domain : domains.values()) {
            domain.tick(world);
        }
    }

    public void doSave(IWorld world) {
        int dimId = world.func_201675_m().func_186058_p().func_186068_a();
        for (WorldCacheDomain domain : domains.values()) {
            for (WorldCacheDomain.SaveKey<? extends CachedWorldData> key : domain.getKnownSaveKeys()) {
                CachedWorldData data = domain.getCachedData(dimId, key);
                if (data == null || !data.needsSaving()) continue;
                WorldCacheIOThread.scheduleSave(domain, dimId, data);
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "WorldCacheManager";
    }
}

