/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.util.tick;

import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class TickManager {
    private Map<TickEvent.Type, List<ITickHandler>> registeredTickHandlers = new HashMap<TickEvent.Type, List<ITickHandler>>();

    public TickManager() {
        for (TickEvent.Type type : TickEvent.Type.values()) {
            this.registeredTickHandlers.put(type, new ArrayList());
        }
    }

    public void attachListeners(IEventBus eventBus) {
        eventBus.addListener(this::worldTick);
        eventBus.addListener(this::serverTick);
        eventBus.addListener(this::playerTick);
        eventBus.addListener(this::renderTick);
        eventBus.addListener(this::clientTick);
    }

    public void register(ITickHandler handler) {
        for (TickEvent.Type type : handler.getHandledTypes()) {
            this.registeredTickHandlers.get(type).add(handler);
        }
    }

    public boolean unregister(ITickHandler handler) {
        boolean removed = true;
        for (TickEvent.Type type : handler.getHandledTypes()) {
            if (this.registeredTickHandlers.get(type).remove(handler)) continue;
            removed = false;
        }
        return removed;
    }

    private void worldTick(TickEvent.WorldTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.WORLD)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.WORLD, event.world);
        }
    }

    private void serverTick(TickEvent.ServerTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.SERVER)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.SERVER, new Object[0]);
        }
    }

    private void clientTick(TickEvent.ClientTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.CLIENT)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.CLIENT, new Object[0]);
        }
    }

    private void renderTick(TickEvent.RenderTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.RENDER)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.RENDER, Float.valueOf(event.renderTickTime));
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        TickEvent.Phase ph = event.phase;
        for (ITickHandler handler : this.registeredTickHandlers.get(TickEvent.Type.PLAYER)) {
            if (!handler.canFire(ph)) continue;
            handler.tick(TickEvent.Type.PLAYER, event.player, event.side);
        }
    }
}

