/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectType;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3i;

public class EffectProperties<T extends EntityVisualFX> {
    private final BatchRenderContext<T> ctx;
    private static List<Consumer<EntityVisualFX>> specialEffects = Lists.newArrayList();
    private EffectType type = null;
    private UUID owner = null;
    private Vec3i position = Vec3i.field_177959_e;
    private boolean ignoreLimit = false;

    public EffectProperties(BatchRenderContext<T> ctx) {
        this.ctx = ctx;
    }

    public <I extends EffectProperties<T>> I setOwner(@Nullable UUID owner) {
        this.owner = owner;
        return (I)this;
    }

    public <I extends EffectProperties<T>> I setType(@Nullable EffectType type) {
        this.type = type;
        return (I)this;
    }

    public <I extends EffectProperties<T>> I setPosition(@Nonnull Vec3i position) {
        this.position = position;
        return (I)this;
    }

    public <I extends EffectProperties<T>> I setIgnoreLimit(boolean ignoreLimit) {
        this.ignoreLimit = ignoreLimit;
        return (I)this;
    }

    public BatchRenderContext<T> getContext() {
        return this.ctx;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Nullable
    public EffectType getType() {
        return this.type;
    }

    @Nonnull
    public Vec3i getPosition() {
        return this.position;
    }

    public boolean ignoresSpawnLimit() {
        return this.ignoreLimit;
    }

    public void applySpecialEffects(EntityVisualFX effect) {
        specialEffects.forEach(s -> s.accept(effect));
    }

    public static void addSpecialEffect(Consumer<EntityVisualFX> effect) {
        specialEffects.add(effect);
    }
}

