/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.context.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.effect.EntityDynamicFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHandler;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.draw.RenderInfo;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.order.OrderSortable;
import hellfirepvp.observerlib.client.util.RenderTypeDecorator;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.Vec3d;

public class BatchRenderContext<T extends EntityVisualFX>
extends OrderSortable {
    private static int counter = 0;
    private final int id = counter++;
    private final SpriteSheetResource sprite;
    protected RenderType renderType;
    protected BiFunction<BatchRenderContext<T>, Vector3, T> particleCreator;

    public BatchRenderContext(RenderType renderType, BiFunction<BatchRenderContext<T>, Vector3, T> particleCreator) {
        this(new SpriteSheetResource(BlockAtlasTexture.getInstance()), renderType, particleCreator);
    }

    public BatchRenderContext(AbstractRenderableTexture texture, RenderType renderType, BiFunction<BatchRenderContext<T>, Vector3, T> particleCreator) {
        this(new SpriteSheetResource(texture), renderType, particleCreator);
    }

    public BatchRenderContext(SpriteSheetResource sprite, RenderType renderType, BiFunction<BatchRenderContext<T>, Vector3, T> particleCreator) {
        this.sprite = sprite;
        this.renderType = renderType;
        this.particleCreator = particleCreator.andThen(fx -> {
            int frames = this.sprite.getFrameCount();
            if (frames > 1) {
                fx.setMaxAge(frames);
            }
            return fx;
        });
    }

    public T makeParticle(Vector3 pos) {
        return (T)((EntityVisualFX)this.particleCreator.apply(this, pos));
    }

    public SpriteSheetResource getSprite() {
        return this.sprite;
    }

    public void renderAll(List<EffectHandler.PendingEffect> effects, MatrixStack renderStack, IDrawRenderTypeBuffer drawBuffer, float pTicks) {
        BatchRenderContext blankCtx = this;
        effects.stream().filter(effect -> effect.getEffect() instanceof EntityDynamicFX).forEach(effect -> ((EntityDynamicFX)((Object)effect.getEffect())).renderNow(blankCtx, renderStack, drawBuffer, pTicks));
        RenderTypeDecorator decorated = RenderTypeDecorator.wrapSetup((RenderType)this.getRenderType(), () -> {
            RenderSystem.enableTexture();
            this.getSprite().bindTexture();
        }, () -> {
            BlockAtlasTexture.getInstance().bindTexture();
            RenderSystem.disableTexture();
        });
        IVertexBuilder buf = drawBuffer.getBuffer((RenderType)decorated);
        effects.forEach(effect -> effect.getEffect().render(this, renderStack, buf, pTicks));
        this.drawBatched(buf, drawBuffer);
    }

    private void drawBatched(IVertexBuilder buf, IDrawRenderTypeBuffer renderTypeBuffer) {
        if (buf instanceof BufferBuilder) {
            Vec3d view = RenderInfo.getInstance().getARI().func_216785_c();
            ((BufferBuilder)buf).func_181674_a((float)view.field_72450_a, (float)view.field_72448_b, (float)view.field_72449_c);
        }
        renderTypeBuffer.draw();
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRenderContext that = (BatchRenderContext)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

