/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.item.base.AlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.AlignmentChargeRevealer;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.awt.Color;
import java.util.EnumSet;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AlignmentChargeRenderer
implements ITickHandler {
    public static final AlignmentChargeRenderer INSTANCE = new AlignmentChargeRenderer();
    private static final int fadeTicks = 15;
    private static final float visibilityChange = 0.06666667f;
    private int revealTicks = 0;
    private float alphaReveal = 0.0f;

    private AlignmentChargeRenderer() {
    }

    public void attachEventListeners(IEventBus bus) {
        bus.addListener(EventPriority.HIGH, this::onRenderOverlay);
    }

    private void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (this.alphaReveal <= 0.0f) {
            return;
        }
        MainWindow window = event.getWindow();
        int screenWidth = window.func_198107_o();
        int screenHeight = window.func_198087_p();
        int barWidth = 194;
        int offsetLeft = screenWidth / 2 - barWidth / 2;
        int offsetTop = screenHeight + 3 - 81;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float percFilled = AlignmentChargeHandler.INSTANCE.getFilledPercentage((PlayerEntity)player, LogicalSide.CLIENT);
        boolean hasEnoughCharge = true;
        float usagePerc = 0.0f;
        for (EquipmentSlotType type : EquipmentSlotType.values()) {
            float max;
            ItemStack equipped = player.func_184582_a(type);
            if (equipped.func_190926_b() || !(equipped.func_77973_b() instanceof AlignmentChargeConsumer)) continue;
            float chargeRequired = ((AlignmentChargeConsumer)equipped.func_77973_b()).getAlignmentChargeCost((PlayerEntity)player, equipped);
            usagePerc = Math.min(chargeRequired / (max = AlignmentChargeHandler.INSTANCE.getMaximumCharge((PlayerEntity)player, LogicalSide.CLIENT)), percFilled);
            hasEnoughCharge = percFilled > usagePerc;
            percFilled -= usagePerc;
            break;
        }
        Tuple<Float, Float> uvColored = SpritesAS.SPR_OVERLAY_CHARGE.getUVOffset();
        Tuple<Float, Float> uvColorless = SpritesAS.SPR_OVERLAY_CHARGE.getUVOffset();
        float width = (float)barWidth * percFilled;
        float usageWidth = (float)barWidth * usagePerc;
        float uLengthCharge = SpritesAS.SPR_OVERLAY_CHARGE.getULength() * percFilled;
        float uLengthUsage = SpritesAS.SPR_OVERLAY_CHARGE_COLORLESS.getULength() * usagePerc;
        Color usageColor = hasEnoughCharge ? ColorsAS.OVERLAY_CHARGE_USAGE : ColorsAS.OVERLAY_CHARGE_MISSING;
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        SpritesAS.SPR_OVERLAY_CHARGE.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, offsetLeft, offsetTop, 10.0f, width, 54.0f).color(1.0f, 1.0f, 1.0f, this.alphaReveal).tex(((Float)uvColored.func_76341_a()).floatValue(), ((Float)uvColored.func_76340_b()).floatValue() + 0.002f, uLengthCharge, SpritesAS.SPR_OVERLAY_CHARGE.getVWidth() - 0.002f).draw());
        SpritesAS.SPR_OVERLAY_CHARGE_COLORLESS.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, (float)offsetLeft + width, offsetTop, 10.0f, usageWidth, 54.0f).color(usageColor.getRed(), usageColor.getGreen(), usageColor.getBlue(), (int)(this.alphaReveal * 255.0f)).tex(((Float)uvColorless.func_76341_a()).floatValue() + uLengthCharge, ((Float)uvColorless.func_76340_b()).floatValue() + 0.002f, uLengthUsage, SpritesAS.SPR_OVERLAY_CHARGE_COLORLESS.getVWidth() - 0.002f).draw());
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        BlockAtlasTexture.getInstance().bindTexture();
    }

    public void tick(TickEvent.Type type, Object ... context) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (AlignmentChargeHandler.INSTANCE.getFilledPercentage((PlayerEntity)player, LogicalSide.CLIENT) <= 0.95f) {
                this.revealCharge(20);
            }
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack stack = player.func_184582_a(slot);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof AlignmentChargeRevealer) || !((AlignmentChargeRevealer)stack.func_77973_b()).shouldReveal(stack)) continue;
                this.revealCharge(20);
                break;
            }
        }
        --this.revealTicks;
        if (this.revealTicks - 15 < 0) {
            if (this.alphaReveal > 0.0f) {
                this.alphaReveal = Math.max(0.0f, this.alphaReveal - 0.06666667f);
            }
        } else if (this.alphaReveal < 1.0f) {
            this.alphaReveal = Math.min(1.0f, this.alphaReveal + 0.06666667f);
        }
    }

    public void revealCharge(int forTicks) {
        this.revealTicks = forTicks;
    }

    public void resetChargeReveal() {
        this.revealTicks = 0;
        this.alphaReveal = 0.0f;
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Alignment Charge Renderer";
    }
}

