/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.base.PerkExperienceRevealer;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class PerkExperienceRenderer
implements ITickHandler {
    public static final PerkExperienceRenderer INSTANCE = new PerkExperienceRenderer();
    private static final int fadeTicks = 15;
    private static final float visibilityChange = 0.06666667f;
    private int revealTicks = 0;
    private float visibilityReveal = 0.0f;

    private PerkExperienceRenderer() {
    }

    public void attachEventListeners(IEventBus bus) {
        bus.addListener(EventPriority.HIGH, this::onRenderOverlay);
    }

    private void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (this.visibilityReveal <= 0.0f) {
            return;
        }
        if (ResearchHelper.getClientProgress().getAttunedConstellation() == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float frameHeight = 128.0f;
        float frameWidth = 32.0f;
        float frameOffsetX = 0.0f;
        float frameOffsetY = 5.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        TexturesAS.TEX_OVERLAY_EXP_FRAME.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, frameOffsetX, frameOffsetY, 10.0f, frameWidth, frameHeight).color(1.0f, 1.0f, 1.0f, this.visibilityReveal * 0.9f).draw());
        float perc = ResearchHelper.getClientProgress().getPercentToNextLevel((PlayerEntity)player, LogicalSide.CLIENT);
        float expHeight = 78.0f * perc;
        float expWidth = 32.0f;
        float expOffsetX = 0.0f;
        float expOffsetY = 27.5f + (1.0f - perc) * 78.0f;
        TexturesAS.TEX_OVERLAY_EXP_BAR.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, expOffsetX, expOffsetY, 10.0f, expWidth, expHeight).color(1.0f, 0.9f, 0.0f, this.visibilityReveal * 0.9f).tex(0.0f, 0.0f, 1.0f, 1.0f - perc).draw());
        String strLevel = String.valueOf(ResearchHelper.getClientProgress().getPerkLevel((PlayerEntity)player, LogicalSide.CLIENT));
        int strLength = Minecraft.func_71410_x().field_71466_p.func_78256_a(strLevel);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(15 - strLength / 2), (double)94.0, (double)20.0);
        RenderSystem.scaled((double)1.2, (double)1.2, (double)1.2);
        int c = 0xDDDDDD;
        c |= (int)(255.0f * this.visibilityReveal) << 24;
        if ((double)this.visibilityReveal > 1.0E-5) {
            RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, 0.0f, Minecraft.func_71410_x().field_71466_p, strLevel, c, true);
        }
        RenderSystem.popMatrix();
        BlockAtlasTexture.getInstance().bindTexture();
    }

    public void tick(TickEvent.Type type, Object ... context) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
            if (!held.func_190926_b() && held.func_77973_b() instanceof PerkExperienceRevealer && ((PerkExperienceRevealer)held.func_77973_b()).shouldReveal(held)) {
                this.revealExperience(20);
            }
            if (!(held = player.func_184586_b(Hand.OFF_HAND)).func_190926_b() && held.func_77973_b() instanceof PerkExperienceRevealer && ((PerkExperienceRevealer)held.func_77973_b()).shouldReveal(held)) {
                this.revealExperience(20);
            }
        }
        --this.revealTicks;
        if (this.revealTicks - 15 < 0) {
            if (this.visibilityReveal > 0.0f) {
                this.visibilityReveal = Math.max(0.0f, this.visibilityReveal - 0.06666667f);
            }
        } else if (this.visibilityReveal < 1.0f) {
            this.visibilityReveal = Math.min(1.0f, this.visibilityReveal + 0.06666667f);
        }
    }

    public void revealExperience(int forTicks) {
        this.revealTicks = forTicks;
    }

    public void resetReveal() {
        this.revealTicks = 0;
        this.visibilityReveal = 0.0f;
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Perk Experience Renderer";
    }
}

