/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event.effect;

import hellfirepvp.astralsorcery.client.data.config.entry.RenderingConfig;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientLightConnections;
import hellfirepvp.astralsorcery.common.tile.TileLens;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;

public class LightbeamRenderHelper
implements ITickHandler {
    private static final LightbeamRenderHelper INSTANCE = new LightbeamRenderHelper();
    private int ticksExisted = 0;

    private LightbeamRenderHelper() {
    }

    public static void attachTickListener(Consumer<ITickHandler> registrar) {
        registrar.accept(INSTANCE);
    }

    public void tick(TickEvent.Type type, Object ... context) {
        ++this.ticksExisted;
        if (this.ticksExisted % 35 == 0) {
            this.ticksExisted = 0;
            Entity rView = Minecraft.func_71410_x().func_175606_aa();
            if (rView == null) {
                rView = Minecraft.func_71410_x().field_71439_g;
            }
            if (rView != null) {
                Entity renderView = rView;
                DimensionType dimType = renderView.func_130014_f_().func_201675_m().func_186058_p();
                SyncDataHolder.executeClient(SyncDataHolder.DATA_LIGHT_CONNECTIONS, ClientLightConnections.class, data -> {
                    for (Map.Entry<BlockPos, Set<BlockPos>> entry : data.getClientConnections(dimType).entrySet()) {
                        BlockPos at = entry.getKey();
                        if (!(renderView.func_70092_e((double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p()) <= RenderingConfig.CONFIG.getMaxEffectRenderDistanceSq())) continue;
                        Vector3 source = new Vector3((Vec3i)at).add(0.5, 0.5, 0.5);
                        Color overlay = null;
                        TileLens lens = MiscUtils.getTileAt((IBlockReader)renderView.func_130014_f_(), at, TileLens.class, true);
                        if (lens != null && lens.getColorType() != null) {
                            overlay = lens.getColorType().getColor();
                        }
                        for (BlockPos dst : entry.getValue()) {
                            Vector3 to = new Vector3((Vec3i)dst).add(0.5, 0.5, 0.5);
                            FXLightbeam beam = (FXLightbeam)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM_TRANSFER).spawn(source)).setup(to, 0.4, 0.4).setAlphaMultiplier(0.4f);
                            if (overlay == null) continue;
                            beam.color(VFXColorFunction.constant(overlay));
                        }
                    }
                });
            }
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Lightbeam Render Helper";
    }
}

