/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.lib.RenderTypesAS;
import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.obj.WavefrontObject;
import hellfirepvp.observerlib.client.util.BufferDecoratorBuilder;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexBuffer;

public class ObjModelRender {
    private static WavefrontObject crystalModel;
    private static WavefrontObject celestialWingsModel;
    private static VertexBuffer vboCelestialWings;
    private static WavefrontObject wraithWingsModel;
    private static VertexBuffer wraithWingsBones;
    private static VertexBuffer wraithWingsWing;

    public static void renderCrystal(MatrixStack renderStack, IVertexBuilder buf, Runnable drawFn) {
        if (crystalModel == null) {
            crystalModel = AssetLoader.loadObjModel(AssetLoader.ModelLocation.OBJ, "crystal");
        }
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)renderStack.func_227866_c_().func_227870_a_());
        crystalModel.render(buf);
        drawFn.run();
        RenderSystem.popMatrix();
    }

    public static void renderCelestialWings(MatrixStack renderStack) {
        if (celestialWingsModel == null) {
            celestialWingsModel = AssetLoader.loadObjModel(AssetLoader.ModelLocation.OBJ, "celestial_wings");
        }
        if (vboCelestialWings == null) {
            int[] lightGray = new int[]{178, 178, 178, 255};
            BufferDecoratorBuilder.withColor((r, g, b, a) -> lightGray).decorate(Tessellator.func_178181_a().func_178180_c(), decorated -> {
                vboCelestialWings = celestialWingsModel.batch((BufferBuilder)decorated);
            });
        }
        vboCelestialWings.func_177359_a();
        RenderTypesAS.POSITION_COLOR_TEX_NORMAL.func_227892_a_(0L);
        vboCelestialWings.func_227874_a_(renderStack.func_227866_c_().func_227870_a_(), celestialWingsModel.getGLDrawingMode());
        RenderTypesAS.POSITION_COLOR_TEX_NORMAL.func_227895_d_();
        VertexBuffer.func_177361_b();
    }

    public static void renderWraithWings(MatrixStack renderStack) {
        if (wraithWingsModel == null) {
            wraithWingsModel = AssetLoader.loadObjModel(AssetLoader.ModelLocation.OBJ, "wraith_wings");
        }
        if (wraithWingsBones == null) {
            int[] gray = new int[]{77, 77, 77, 255};
            BufferDecoratorBuilder.withColor((r, g, b, a) -> gray).decorate(Tessellator.func_178181_a().func_178180_c(), decorated -> {
                wraithWingsBones = wraithWingsModel.batchOnly((BufferBuilder)decorated, "Bones");
            });
        }
        if (wraithWingsWing == null) {
            int[] black = new int[]{0, 0, 0, 255};
            BufferDecoratorBuilder.withColor((r, g, b, a) -> black).decorate(Tessellator.func_178181_a().func_178180_c(), decorated -> {
                wraithWingsWing = wraithWingsModel.batchOnly((BufferBuilder)decorated, "Wing");
            });
        }
        wraithWingsBones.func_177359_a();
        RenderTypesAS.POSITION_COLOR_TEX_NORMAL.func_227892_a_(0L);
        wraithWingsBones.func_227874_a_(renderStack.func_227866_c_().func_227870_a_(), wraithWingsModel.getGLDrawingMode());
        RenderTypesAS.POSITION_COLOR_TEX_NORMAL.func_227895_d_();
        VertexBuffer.func_177361_b();
        wraithWingsWing.func_177359_a();
        RenderTypesAS.POSITION_COLOR_TEX_NORMAL.func_227892_a_(0L);
        wraithWingsWing.func_227874_a_(renderStack.func_227866_c_().func_227870_a_(), wraithWingsModel.getGLDrawingMode());
        RenderTypesAS.POSITION_COLOR_TEX_NORMAL.func_227895_d_();
        VertexBuffer.func_177361_b();
    }
}

