/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.render.tile.CustomTileEntityRenderer;
import hellfirepvp.astralsorcery.client.util.ColorizationHelper;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.ActiveSimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;

public class RenderAltar
extends CustomTileEntityRenderer<TileAltar> {
    public RenderAltar(TileEntityRendererDispatcher tileRenderer) {
        super(tileRenderer);
    }

    public void render(TileAltar tile, float pTicks, MatrixStack renderStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        ActiveSimpleAltarRecipe recipe;
        IConstellation cst;
        if (tile.getAltarType().isThisGEThan(AltarType.RADIANCE) && tile.hasMultiblock() && (cst = tile.getFocusedConstellation()) != null) {
            float dayAlpha = DayTimeHelper.getCurrentDaytimeDistribution(tile.func_145831_w()) * 0.6f;
            int max = 3000;
            int t = (int)(ClientScheduler.getClientTick() % (long)max);
            float halfAge = (float)max / 2.0f;
            float tr = 1.0f - Math.abs(halfAge - (float)t) / halfAge;
            tr = (float)((double)tr * 1.3);
            RenderingConstellationUtils.renderConstellationIntoWorldFlat(cst, renderStack, renderTypeBuffer, new Vector3(0.5, 0.03, 0.5), 5.5 + (double)tr, 2.0, 0.1f + dayAlpha);
        }
        if ((recipe = tile.getActiveRecipe()) != null) {
            recipe.getRecipeToCraft().getCraftingEffects().forEach(effect -> effect.onTESR(tile, recipe.getState(), renderStack, renderTypeBuffer, pTicks, combinedLight));
        }
        if (tile.getAltarType().isThisGEThan(AltarType.RADIANCE)) {
            renderStack.func_227860_a_();
            renderStack.func_227861_a_(0.5, 4.5, 0.5);
            long id = tile.func_174877_v().func_218275_a();
            if (recipe != null) {
                List<WrappedIngredient> traitInputs = recipe.getRecipeToCraft().getRelayInputs();
                if (!traitInputs.isEmpty()) {
                    int amount = 60 / traitInputs.size();
                    for (int i = 0; i < traitInputs.size(); ++i) {
                        WrappedIngredient ingredient = traitInputs.get(i);
                        ItemStack traitInput = ingredient.getRandomMatchingStack(ClientScheduler.getClientTick());
                        Color color = ColorizationHelper.getColor(traitInput).orElse(ColorsAS.CELESTIAL_CRYSTAL);
                        RenderingDrawUtils.renderLightRayFan(renderStack, renderTypeBuffer, color, 0x1231943167156902L | id | (long)i * 20817L, 20, 2.0f, amount);
                    }
                } else {
                    RenderingDrawUtils.renderLightRayFan(renderStack, renderTypeBuffer, Color.WHITE, id * 31L, 15, 1.5f, 35);
                    RenderingDrawUtils.renderLightRayFan(renderStack, renderTypeBuffer, ColorsAS.CELESTIAL_CRYSTAL, id * 16L, 10, 1.0f, 25);
                }
                RenderingDrawUtils.renderLightRayFan(renderStack, renderTypeBuffer, Color.WHITE, id * 31L, 10, 1.0f, 10);
            } else {
                RenderingDrawUtils.renderLightRayFan(renderStack, renderTypeBuffer, Color.WHITE, id * 31L, 15, 1.5f, 35);
                RenderingDrawUtils.renderLightRayFan(renderStack, renderTypeBuffer, ColorsAS.CELESTIAL_CRYSTAL, id * 16L, 10, 1.0f, 25);
            }
            renderStack.func_227865_b_();
        }
    }
}

