/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.model.builtin.ModelAttunementAltar;
import hellfirepvp.astralsorcery.client.render.tile.CustomTileEntityRenderer;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.MathHelper;

public class RenderAttunementAltar
extends CustomTileEntityRenderer<TileAttunementAltar> {
    private static final ModelAttunementAltar MODEL_ATTUNEMENT_ALTAR = new ModelAttunementAltar();

    public RenderAttunementAltar(TileEntityRendererDispatcher tileRenderer) {
        super(tileRenderer);
    }

    public void render(TileAttunementAltar tile, float pTicks, MatrixStack renderStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        IVertexBuilder buf = renderTypeBuffer.getBuffer(MODEL_ATTUNEMENT_ALTAR.getGeneralType());
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(0.5, 0.5, 0.5);
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        MODEL_ATTUNEMENT_ALTAR.render(renderStack, buf, combinedLight, combinedOverlay);
        renderStack.func_227865_b_();
        float spinDur = 100.0f;
        float spinStart = 60.0f;
        float startY = -1.2f;
        float endY = -0.5f;
        float tickPartY = (endY - startY) / spinStart;
        float prevPosY = endY + (float)tile.prevActivationTick * tickPartY;
        float posY = endY + (float)tile.activationTick * tickPartY;
        float framePosY = RenderingVectorUtils.interpolate(prevPosY, posY, pTicks);
        double generalAnimationTick = (double)((float)ClientScheduler.getClientTick() + pTicks) / 4.0;
        if (tile.animate) {
            if (tile.tesrLocked) {
                tile.tesrLocked = false;
            }
        } else if (tile.tesrLocked) {
            generalAnimationTick = 7.25;
        } else if (Math.abs(generalAnimationTick % (double)spinDur - 7.25) <= 0.3125) {
            generalAnimationTick = 7.25;
            tile.tesrLocked = true;
        }
        for (int i = 1; i < 9; ++i) {
            float incrementer = spinDur / 8.0f * (float)i;
            double aFrame = generalAnimationTick + (double)incrementer;
            double prevAFrame = generalAnimationTick + (double)incrementer - 1.0;
            double renderFrame = RenderingVectorUtils.interpolate(prevAFrame, aFrame, 0.0f);
            double partRenderFrame = renderFrame % (double)spinDur / (double)spinDur;
            float normalized = (float)(partRenderFrame * 2.0 * Math.PI);
            float xOffset = MathHelper.func_76134_b((float)normalized);
            float zOffset = MathHelper.func_76126_a((float)normalized);
            float rotation = RenderingVectorUtils.interpolate((float)tile.prevActivationTick / spinStart, (float)tile.activationTick / spinStart, pTicks);
            renderStack.func_227860_a_();
            renderStack.func_227861_a_(0.5, (double)framePosY, 0.5);
            renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            MODEL_ATTUNEMENT_ALTAR.renderHovering(renderStack, buf, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f, xOffset, zOffset, rotation);
            renderStack.func_227865_b_();
        }
    }
}

