/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.WidthHeightScreen;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class ScreenConstellationPaper
extends WidthHeightScreen {
    private final IConstellation constellation;
    private List<MoonPhase> phases = null;

    public ScreenConstellationPaper(IConstellation cst) {
        super(cst.getConstellationName(), 344, 275);
        this.constellation = cst;
        this.resolvePhases();
    }

    private void resolvePhases() {
        WorldContext ctx = SkyHandler.getContext((World)Minecraft.func_71410_x().field_71441_e, LogicalSide.CLIENT);
        if (ctx != null) {
            this.phases = new ArrayList<MoonPhase>();
            for (MoonPhase phase : MoonPhase.values()) {
                if (!ctx.getConstellationHandler().isActiveInPhase(this.constellation, phase)) continue;
                this.phases.add(phase);
            }
        }
    }

    public void onClose() {
        super.onClose();
        SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_CLOSE, 1.0f, 1.0f);
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        this.drawWHRect(TexturesAS.TEX_GUI_CONSTELLATION_PAPER);
        this.drawHeader();
        this.drawConstellation();
        this.drawPhaseInformation();
    }

    private void drawHeader() {
        String locName = this.constellation.getConstellationName().func_150254_d().toUpperCase();
        double length = (double)this.font.func_78256_a(locName) * 1.8;
        double offsetLeft = (double)(this.width >> 1) - length / 2.0;
        int offsetTop = this.guiTop + 45;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(offsetLeft + 2.0), (double)offsetTop, (double)0.0);
        RenderSystem.scaled((double)1.8, (double)1.8, (double)1.8);
        RenderingDrawUtils.renderStringAtCurrentPos(this.font, locName, -1437774515);
        RenderSystem.popMatrix();
    }

    private void drawConstellation() {
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderingConstellationUtils.renderConstellationIntoGUI(ColorsAS.CONSTELLATION_TYPE_BLANK, this.constellation, this.width / 2 - 72, this.guiTop + 84, this.getGuiZLevel(), 145.0f, 145.0f, 2.0, () -> Float.valueOf(0.5f), true, false);
        RenderSystem.disableBlend();
    }

    private void drawPhaseInformation() {
        List<Object> phases;
        if (this.phases == null) {
            this.resolvePhases();
        }
        List<Object> list = phases = this.phases == null ? Collections.emptyList() : this.phases;
        if (phases.isEmpty()) {
            RenderingDrawUtils.renderStringCentered(Minecraft.func_71410_x().field_71466_p, "? ? ?", this.guiLeft + this.guiWidth / 2 + 25, this.guiTop + 239, 1.8f, -1437774515);
        } else {
            int size = 16;
            int offsetX = this.width / 2 - phases.size() * (size + 2) / 2;
            int offsetY = this.guiTop + 237;
            for (int i = 0; i < phases.size(); ++i) {
                ((MoonPhase)((Object)phases.get(i))).getTexture().bindTexture();
                RenderSystem.enableBlend();
                Blending.DEFAULT.apply();
                RenderingGuiUtils.drawRect(offsetX + i * (size + 2), offsetY, this.getGuiZLevel(), size, size);
                RenderSystem.disableBlend();
            }
        }
    }
}

