/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.screen.base.WidthHeightScreen;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalProgression;
import hellfirepvp.astralsorcery.client.screen.journal.bookmark.BookmarkProvider;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class ScreenJournal
extends WidthHeightScreen {
    public static final int NO_BOOKMARK = -1;
    protected static List<BookmarkProvider> bookmarks = Lists.newArrayList();
    protected final int bookmarkIndex;
    protected Map<Rectangle, BookmarkProvider> drawnBookmarks = Maps.newHashMap();

    protected ScreenJournal(ITextComponent titleIn, int bookmarkIndex) {
        this(titleIn, 270, 420, bookmarkIndex);
    }

    public ScreenJournal(ITextComponent titleIn, int guiHeight, int guiWidth, int bookmarkIndex) {
        super(titleIn, guiHeight, guiWidth);
        this.bookmarkIndex = bookmarkIndex;
    }

    public static boolean addBookmark(BookmarkProvider bookmarkProvider) {
        int index = bookmarkProvider.getIndex();
        if (MiscUtils.contains(bookmarks, bm -> bm.getIndex() == index)) {
            return false;
        }
        bookmarks.add(bookmarkProvider);
        return true;
    }

    protected void drawDefault(AbstractRenderableTexture texture, int mouseX, int mouseY) {
        this.changeZLevel(100);
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        this.drawWHRect(texture);
        RenderSystem.disableBlend();
        this.drawBookmarks(mouseX, mouseY);
        this.changeZLevel(-100);
    }

    private void drawBookmarks(int mouseX, int mouseY) {
        this.drawnBookmarks.clear();
        float bookmarkWidth = 67.0f;
        float bookmarkHeight = 15.0f;
        float bookmarkGap = 18.0f;
        float offsetX = (float)(this.guiLeft + this.guiWidth) - 17.25f;
        float offsetY = this.guiTop + 20;
        bookmarks.sort(Comparator.comparing(BookmarkProvider::getIndex));
        for (BookmarkProvider bookmarkProvider : bookmarks) {
            if (!bookmarkProvider.canSee()) continue;
            Rectangle r = this.drawBookmark(offsetX, offsetY, bookmarkWidth, bookmarkHeight, bookmarkWidth + (float)(this.bookmarkIndex == bookmarkProvider.getIndex() ? 0 : 5), this.getGuiZLevel(), bookmarkProvider.getUnlocalizedName(), -572662307, mouseX, mouseY, bookmarkProvider.getTextureBookmark(), bookmarkProvider.getTextureBookmarkStretched());
            this.drawnBookmarks.put(r, bookmarkProvider);
            offsetY += bookmarkGap;
        }
    }

    private Rectangle drawBookmark(float offsetX, float offsetY, float width, float height, float mouseOverWidth, float zLevel, String title, int titleRGBColor, int mouseX, int mouseY, AbstractRenderableTexture texture, AbstractRenderableTexture textureStretched) {
        texture.bindTexture();
        Rectangle r = new Rectangle(MathHelper.func_76141_d((float)offsetX), MathHelper.func_76141_d((float)offsetY), MathHelper.func_76141_d((float)width), MathHelper.func_76141_d((float)height));
        if (r.contains(mouseX, mouseY)) {
            if (mouseOverWidth > width) {
                textureStretched.bindTexture();
            }
            width = mouseOverWidth;
            r = new Rectangle(MathHelper.func_76141_d((float)offsetX), MathHelper.func_76141_d((float)offsetY), MathHelper.func_76141_d((float)width), MathHelper.func_76141_d((float)height));
        }
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        float actualWidth = width;
        RenderingUtils.draw(7, DefaultVertexFormats.field_181707_g, buf -> RenderingGuiUtils.rect(buf, offsetX, offsetY, zLevel, actualWidth, height).draw());
        RenderSystem.disableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(offsetX + 2.0f), (double)(offsetY + 4.0f), (double)(zLevel + 50.0f));
        RenderSystem.scaled((double)0.7, (double)0.7, (double)0.7);
        RenderingDrawUtils.renderStringAtCurrentPos(null, I18n.func_135052_a((String)title, (Object[])new Object[0]), titleRGBColor);
        RenderSystem.popMatrix();
        return r;
    }

    protected boolean handleBookmarkClick(double mouseX, double mouseY) {
        return this.handleJournalNavigationBookmarkClick(mouseX, mouseY);
    }

    private boolean handleJournalNavigationBookmarkClick(double mouseX, double mouseY) {
        for (Rectangle bookmarkRectangle : this.drawnBookmarks.keySet()) {
            BookmarkProvider provider = this.drawnBookmarks.get(bookmarkRectangle);
            if (this.bookmarkIndex == provider.getIndex() || !bookmarkRectangle.contains(mouseX, mouseY)) continue;
            ScreenJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a(provider.getGuiScreen());
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

