/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.NavigationArrowScreen;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalProgression;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.common.data.journal.JournalPage;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class ScreenJournalPages
extends ScreenJournal
implements NavigationArrowScreen {
    private static ScreenJournalPages openGuiInstance;
    private static boolean saveSite;
    @Nullable
    private final ScreenJournalProgression origin;
    @Nullable
    private final Screen previous;
    private final ResearchNode researchNode;
    private List<RenderablePage> pages;
    private boolean informPreviousClose = true;
    private int currentPageOffset = 0;
    private Rectangle rectBack;
    private Rectangle rectNext;
    private Rectangle rectPrev;

    public ScreenJournalPages(@Nullable ScreenJournalProgression origin, ResearchNode node) {
        super(node.getName(), -1);
        this.researchNode = node;
        this.origin = origin;
        this.previous = null;
        List<JournalPage> pageList = node.getPages();
        this.pages = new ArrayList<RenderablePage>(pageList.size());
        for (int i = 0; i < pageList.size(); ++i) {
            this.pages.add(pageList.get(i).buildRenderPage(node, i));
        }
    }

    public ScreenJournalPages(@Nullable Screen previous, ResearchNode detailedInformation, int exactPage) {
        super(detailedInformation.getName(), -1);
        this.researchNode = detailedInformation;
        this.origin = null;
        this.previous = previous;
        this.currentPageOffset = exactPage / 2;
        List<JournalPage> pageList = detailedInformation.getPages();
        this.pages = new ArrayList<RenderablePage>(pageList.size());
        for (int i = 0; i < pageList.size(); ++i) {
            this.pages.add(pageList.get(i).buildRenderPage(detailedInformation, i));
        }
    }

    public static ScreenJournalPages getClearOpenGuiInstance() {
        ScreenJournalPages gui = openGuiInstance;
        openGuiInstance = null;
        return gui;
    }

    public int getCurrentPageOffset() {
        return this.currentPageOffset;
    }

    public ResearchNode getResearchNode() {
        return this.researchNode;
    }

    @Override
    public void init() {
        super.init();
        if (this.origin != null) {
            this.origin.preventRefresh();
            this.origin.setSize(this.width, this.height);
            this.origin.init();
        }
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        super.render(mouseX, mouseY, pTicks);
        if (this.origin != null) {
            this.drawDefault(TexturesAS.TEX_GUI_BOOK_BLANK, mouseX, mouseY);
        } else {
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            this.drawWHRect(TexturesAS.TEX_GUI_BOOK_BLANK);
            RenderSystem.disableBlend();
        }
        this.changeZLevel(100);
        int pageYOffset = 20;
        if (this.currentPageOffset == 0) {
            RenderSystem.pushMatrix();
            String headline = this.getTitle().func_150254_d();
            double width = this.font.func_78256_a(headline);
            RenderSystem.translated((double)(this.guiLeft + 117), (double)(this.guiTop + 22), (double)this.getGuiZLevel());
            RenderSystem.scaled((double)1.3, (double)1.3, (double)1.3);
            RenderSystem.translated((double)(-(width / 2.0)), (double)0.0, (double)0.0);
            RenderingDrawUtils.renderStringAtCurrentPos(this.font, headline, 0xDDDDDD);
            RenderSystem.popMatrix();
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            TexturesAS.TEX_GUI_BOOK_UNDERLINE.bindTexture();
            RenderingGuiUtils.drawRect(this.guiLeft + 30, this.guiTop + 35, this.getGuiZLevel(), 175, 6);
            RenderSystem.disableBlend();
            pageYOffset += 30;
        }
        int index = this.currentPageOffset * 2;
        if (this.pages.size() > index) {
            RenderablePage page = this.pages.get(index);
            page.render(this.guiLeft + 30, this.guiTop + pageYOffset, pTicks, this.getGuiZLevel(), mouseX, mouseY);
        }
        if (this.pages.size() > ++index) {
            RenderablePage page = this.pages.get(index);
            page.render(this.guiLeft + 220, this.guiTop + 20, pTicks, this.getGuiZLevel(), mouseX, mouseY);
        }
        this.changeZLevel(20);
        this.drawNavArrows(pTicks, mouseX, mouseY);
        this.changeZLevel(-20);
        index = this.currentPageOffset * 2;
        if (this.pages.size() > index) {
            RenderablePage page = this.pages.get(index);
            page.postRender(this.guiLeft + 30, this.guiTop + pageYOffset, pTicks, this.getGuiZLevel(), mouseX, mouseY);
        }
        if (this.pages.size() > ++index) {
            RenderablePage page = this.pages.get(index);
            page.postRender(this.guiLeft + 220, this.guiTop + 20, pTicks, this.getGuiZLevel(), mouseX, mouseY);
        }
        this.changeZLevel(-100);
    }

    private void drawNavArrows(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        this.rectNext = null;
        this.rectPrev = null;
        this.rectBack = this.drawArrow(this.guiLeft + 197, this.guiTop + 230, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, partialTicks);
        int cIndex = this.currentPageOffset * 2;
        if (cIndex > 0) {
            this.rectPrev = this.drawArrow(this.guiLeft + 25, this.guiTop + 220, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, partialTicks);
        }
        int nextIndex = cIndex + 2;
        if (this.pages.size() >= nextIndex + 1) {
            this.rectNext = this.drawArrow(this.guiLeft + 367, this.guiTop + 220, this.getGuiZLevel(), NavigationArrowScreen.Type.RIGHT, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        if (this.origin != null) {
            this.origin.expectReInit();
            saveSite = false;
        } else {
            this.informPreviousClose = false;
        }
        return true;
    }

    public void onClose() {
        if (this.origin != null) {
            if (saveSite) {
                openGuiInstance = this;
                ScreenJournalProgression.getJournalInstance().preventRefresh();
                Minecraft.func_71410_x().func_147108_a(null);
            } else {
                saveSite = true;
                openGuiInstance = null;
                Minecraft.func_71410_x().func_147108_a((Screen)this.origin);
            }
        } else {
            if (this.previous != null && this.informPreviousClose) {
                this.previous.onClose();
            }
            Minecraft.func_71410_x().func_147108_a(this.previous);
        }
    }

    @Override
    protected void mouseDragTick(double mouseX, double mouseY, double mouseDiffX, double mouseDiffY, double mouseOffsetX, double mouseOffsetY) {
        RenderablePage page;
        int index = this.currentPageOffset * 2;
        if (this.pages.size() > index && (page = this.pages.get(index)) != null && page.propagateMouseDrag(mouseOffsetX, mouseOffsetY)) {
            return;
        }
        if (this.pages.size() > ++index && (page = this.pages.get(index)) != null) {
            page.propagateMouseDrag(mouseOffsetX, mouseOffsetY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        RenderablePage page;
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 1) {
            return true;
        }
        if (mouseButton != 0) {
            return false;
        }
        if (this.origin != null && this.handleBookmarkClick(mouseX, mouseY)) {
            saveSite = false;
            return true;
        }
        if (this.rectBack != null && this.rectBack.contains(mouseX, mouseY)) {
            if (this.origin != null) {
                this.origin.expectReInit();
                saveSite = false;
                this.onClose();
                return true;
            }
            this.informPreviousClose = false;
            this.onClose();
            return true;
        }
        if (this.rectPrev != null && this.rectPrev.contains(mouseX, mouseY)) {
            --this.currentPageOffset;
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.rectNext != null && this.rectNext.contains(mouseX, mouseY)) {
            ++this.currentPageOffset;
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        int index = this.currentPageOffset * 2;
        if (this.pages.size() > index && (page = this.pages.get(index)) != null && page.propagateMouseClick(mouseX, mouseY)) {
            return true;
        }
        return this.pages.size() > ++index && (page = this.pages.get(index)) != null && page.propagateMouseClick(mouseX, mouseY);
    }

    static {
        saveSite = true;
    }
}

