/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalPages;
import hellfirepvp.astralsorcery.client.screen.journal.progression.ScreenJournalProgressionRenderer;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.ScreenTextEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class ScreenJournalProgression
extends ScreenJournal {
    private static ScreenJournalProgression currentInstance = null;
    private boolean expectReinit = false;
    private boolean rescaleAndRefresh = true;
    private ScreenTextEntry searchTextEntry = new ScreenTextEntry();
    private static final int searchEntriesLeft = 15;
    private static final int searchEntriesRight = 14;
    private static final int searchEntryDrawWidth = 170;
    private int searchPageOffset = 0;
    private Rectangle searchPrevRct;
    private Rectangle searchNextRct;
    private ResearchNode searchHoverNode = null;
    private List<ResearchNode> searchResult = new ArrayList<ResearchNode>();
    private Map<Integer, List<ResearchNode>> searchResultPageIndex = Maps.newHashMap();
    private static ScreenJournalProgressionRenderer progressionRenderer;

    private ScreenJournalProgression() {
        super((ITextComponent)new TranslationTextComponent("screen.astralsorcery.tome.progression", new Object[0]), 10);
        this.searchTextEntry.setChangeCallback(this::onSearchTextInput);
    }

    public static ScreenJournalProgression getJournalInstance() {
        if (currentInstance != null) {
            return currentInstance;
        }
        return new ScreenJournalProgression();
    }

    public static ScreenJournal getOpenJournalInstance() {
        ScreenJournal gui = ScreenJournalPages.getClearOpenGuiInstance();
        if (gui == null) {
            gui = ScreenJournalProgression.getJournalInstance();
        }
        return gui;
    }

    public void expectReInit() {
        this.expectReinit = true;
    }

    public void preventRefresh() {
        this.rescaleAndRefresh = false;
    }

    public static void resetJournal() {
        currentInstance = null;
        ScreenJournalPages.getClearOpenGuiInstance();
    }

    public void removed() {
        super.removed();
        this.rescaleAndRefresh = false;
    }

    @Override
    protected void init() {
        super.init();
        if (this.expectReinit) {
            this.expectReinit = false;
            return;
        }
        if (currentInstance == null || progressionRenderer == null) {
            currentInstance = this;
            progressionRenderer = new ScreenJournalProgressionRenderer(currentInstance);
            progressionRenderer.centerMouse();
        }
        progressionRenderer.updateOffset(this.guiLeft + 10, this.guiTop + 10);
        progressionRenderer.setBox(10, 10, this.guiWidth - 10, this.guiHeight - 10);
        if (this.rescaleAndRefresh) {
            progressionRenderer.resetZoom();
            progressionRenderer.unfocus();
            progressionRenderer.refreshSize();
            progressionRenderer.updateMouseState();
        } else {
            this.rescaleAndRefresh = true;
        }
    }

    private boolean inProgressView() {
        return this.searchTextEntry.getText().length() < 3;
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        super.render(mouseX, mouseY, pTicks);
        this.searchPrevRct = null;
        this.searchNextRct = null;
        this.searchHoverNode = null;
        if (this.inProgressView()) {
            this.searchPageOffset = 0;
            this.renderProgressView(mouseX, mouseY, pTicks);
        } else {
            this.renderSearchView(mouseX, mouseY, pTicks);
        }
    }

    private void renderSearchView(int mouseX, int mouseY, float pTicks) {
        this.drawDefault(TexturesAS.TEX_GUI_BOOK_BLANK, mouseX, mouseY);
        this.changeZLevel(150);
        this.drawSearchResults(mouseX, mouseY, pTicks);
        this.drawSearchBox();
        this.changeZLevel(20);
        this.drawSearchPageNavArrows(mouseX, mouseY, pTicks);
        this.changeZLevel(-170);
    }

    private void renderProgressView(int mouseX, int mouseY, float pTicks) {
        double guiFactor = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)MathHelper.func_76128_c((double)((double)(this.guiLeft + 27) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.guiTop + 27) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.guiWidth - 54) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.guiHeight - 54) * guiFactor)));
        progressionRenderer.drawProgressionPart(this.getGuiZLevel(), mouseX, mouseY);
        GL11.glDisable((int)3089);
        RenderSystem.disableDepthTest();
        this.drawDefault(TexturesAS.TEX_GUI_BOOK_FRAME_FULL, mouseX, mouseY);
        RenderSystem.enableDepthTest();
        this.drawSearchBox();
        this.changeZLevel(150);
        this.drawMouseHighlight(this.getGuiZLevel(), mouseX, mouseY);
        this.changeZLevel(-150);
    }

    private void drawSearchResults(int mouseX, int mouseY, float pTicks) {
        Object rctDrawn;
        float length;
        float maxLength;
        List nodeTitleLines;
        int startOffsetY;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int lineHeight = 12;
        int offsetX = this.getGuiLeft() + 35;
        int offsetY = this.getGuiTop() + 26;
        double effectPart = (Math.sin(Math.toRadians((double)ClientScheduler.getClientTick() * 5.0 % 360.0)) + 1.0) / 2.0;
        int alpha = Math.round((0.45f + 0.1f * (float)effectPart) * 255.0f);
        int grayScale = Math.round((0.7f + 0.2f * (float)effectPart) * 255.0f);
        Color boxColor = new Color(grayScale, grayScale, grayScale, alpha);
        List entries = this.searchResultPageIndex.getOrDefault(this.searchPageOffset, new ArrayList());
        for (ResearchNode node : entries) {
            startOffsetY = offsetY;
            nodeTitleLines = fr.func_78271_c(node.getName().func_150254_d(), 170);
            maxLength = 0.0f;
            for (String line : nodeTitleLines) {
                length = RenderingDrawUtils.renderStringAtPos(offsetX, offsetY, this.getGuiZLevel(), fr, line, 0xD0D0D0, false) - (float)offsetX;
                if (length > maxLength) {
                    maxLength = length;
                }
                offsetY += lineHeight;
            }
            if (this.searchHoverNode != null || !((Rectangle)(rctDrawn = new Rectangle(offsetX - 2, startOffsetY - 2, (int)(maxLength + 4.0f), offsetY - startOffsetY))).contains(mouseX, mouseY)) continue;
            ScreenJournalProgression.fill((int)((Rectangle)rctDrawn).x, (int)((Rectangle)rctDrawn).y, (int)(((Rectangle)rctDrawn).x + ((Rectangle)rctDrawn).width), (int)(((Rectangle)rctDrawn).y + ((Rectangle)rctDrawn).height), (int)boxColor.getRGB());
            this.searchHoverNode = node;
        }
        offsetX = this.getGuiLeft() + 225;
        offsetY = this.getGuiTop() + 39;
        entries = this.searchResultPageIndex.getOrDefault(this.searchPageOffset + 1, new ArrayList());
        for (ResearchNode node : entries) {
            startOffsetY = offsetY;
            nodeTitleLines = fr.func_78271_c(node.getName().func_150254_d(), 170);
            maxLength = 0.0f;
            rctDrawn = nodeTitleLines.iterator();
            while (rctDrawn.hasNext()) {
                String line;
                line = (String)rctDrawn.next();
                length = RenderingDrawUtils.renderStringAtPos(offsetX, offsetY, this.getGuiZLevel(), fr, line, 0xD0D0D0, false) - (float)offsetX;
                if (length > maxLength) {
                    maxLength = length;
                }
                offsetY += lineHeight;
            }
            if (this.searchHoverNode != null || !((Rectangle)(rctDrawn = new Rectangle(offsetX - 2, startOffsetY - 2, (int)(maxLength + 4.0f), offsetY - startOffsetY))).contains(mouseX, mouseY)) continue;
            ScreenJournalProgression.fill((int)((Rectangle)rctDrawn).x, (int)((Rectangle)rctDrawn).y, (int)(((Rectangle)rctDrawn).x + ((Rectangle)rctDrawn).width), (int)(((Rectangle)rctDrawn).y + ((Rectangle)rctDrawn).height), (int)boxColor.getRGB());
            this.searchHoverNode = node;
        }
    }

    private void drawMouseHighlight(float zLevel, int mouseX, int mouseY) {
        progressionRenderer.drawMouseHighlight(zLevel, mouseX, mouseY);
    }

    private void drawSearchBox() {
        boolean addDots;
        TexturesAS.TEX_GUI_TEXT_FIELD.bindTexture();
        RenderSystem.enableBlend();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, this.guiLeft + 300, this.guiTop + 16, this.getGuiZLevel(), 88.5f, 15.0f).draw());
        RenderSystem.disableBlend();
        String text = this.searchTextEntry.getText();
        int length = this.font.func_78256_a(text);
        boolean bl = addDots = length > 75;
        while (length > 75) {
            text = text.substring(1);
            length = this.font.func_78256_a("..." + text);
        }
        if (addDots) {
            text = "..." + text;
        }
        if (ClientScheduler.getClientTick() % 20L > 10L) {
            text = text + "_";
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.guiLeft + 304), (double)(this.guiTop + 20), (double)this.getGuiZLevel());
        RenderingDrawUtils.renderStringAtCurrentPos(this.font, text, 0xCCCCCC);
        RenderSystem.popMatrix();
    }

    private void drawSearchPageNavArrows(int mouseX, int mouseY, float pTicks) {
        if (this.searchPageOffset > 0) {
            float uFrom;
            int width = 30;
            int height = 15;
            this.searchPrevRct = new Rectangle(this.guiLeft + 25, this.guiTop + 220, width, height);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(this.searchPrevRct.getX() + (double)((float)width / 2.0f)), (double)(this.searchPrevRct.getY() + (double)((float)height / 2.0f)), (double)0.0);
            float vFrom = 0.5f;
            if (this.searchPrevRct.contains(mouseX, mouseY)) {
                uFrom = 0.5f;
                RenderSystem.scaled((double)1.1, (double)1.1, (double)1.1);
            } else {
                uFrom = 0.0f;
                double t = (float)ClientScheduler.getClientTick() + pTicks;
                float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                RenderSystem.scaled((double)sin, (double)sin, (double)sin);
            }
            RenderSystem.translated((double)(-((float)width / 2.0f)), (double)(-((float)height / 2.0f)), (double)0.0);
            TexturesAS.TEX_GUI_BOOK_ARROWS.bindTexture();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, 0.0f, 0.0f, this.getGuiZLevel(), width, height).tex(uFrom, vFrom, 0.5f, 0.5f).color(1.0f, 1.0f, 1.0f, 0.8f).draw());
            RenderSystem.popMatrix();
        }
        int nextDoublePageIndex = this.searchPageOffset * 2 + 2;
        if (this.searchResultPageIndex.size() >= nextDoublePageIndex + 1) {
            float uFrom;
            int width = 30;
            int height = 15;
            this.searchNextRct = new Rectangle(this.guiLeft + 367, this.guiTop + 220, width, height);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(this.searchNextRct.getX() + (double)((float)width / 2.0f)), (double)(this.searchNextRct.getY() + (double)((float)height / 2.0f)), (double)0.0);
            float vFrom = 0.0f;
            if (this.searchNextRct.contains(mouseX, mouseY)) {
                uFrom = 0.5f;
                RenderSystem.scaled((double)1.1, (double)1.1, (double)1.1);
            } else {
                uFrom = 0.0f;
                double t = (float)ClientScheduler.getClientTick() + pTicks;
                float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                RenderSystem.scaled((double)sin, (double)sin, (double)sin);
            }
            RenderSystem.translated((double)(-((float)width / 2.0f)), (double)(-((float)height / 2.0f)), (double)0.0);
            TexturesAS.TEX_GUI_BOOK_ARROWS.bindTexture();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, 0.0f, 0.0f, this.getGuiZLevel(), width, height).tex(uFrom, vFrom, 0.5f, 0.5f).color(1.0f, 1.0f, 1.0f, 0.8f).draw());
            RenderSystem.popMatrix();
        }
    }

    private void onSearchTextInput() {
        if (!this.inProgressView() && this.isCurrentlyDragging()) {
            this.stopDragging(-1.0, -1.0);
            progressionRenderer.applyMovedMouseOffset();
        }
        PlayerProgress prog = ResearchHelper.getClientProgress();
        this.searchResult.clear();
        this.searchResultPageIndex.clear();
        String searchText = this.searchTextEntry.getText().toLowerCase();
        for (ResearchProgression research : ResearchProgression.values()) {
            if (!prog.getResearchProgression().contains((Object)research)) continue;
            for (ResearchNode node2 : research.getResearchNodes()) {
                String nodeName = node2.getName().func_150254_d().toLowerCase();
                if (!nodeName.contains(searchText) || this.searchResult.contains(node2)) continue;
                this.searchResult.add(node2);
            }
        }
        this.searchResult.sort(Comparator.comparing(node -> node.getName().func_150254_d()));
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int addedPages = 0;
        int pageIndex = 0;
        while (addedPages < this.searchResult.size()) {
            ResearchNode toAddNode;
            int nodeLines;
            List page;
            int remainingLines = (pageIndex % 2 == 0 ? 15 : 14) - (page = this.searchResultPageIndex.computeIfAbsent(pageIndex, index -> new ArrayList())).size();
            if (remainingLines < (nodeLines = fr.func_78271_c((toAddNode = this.searchResult.get(addedPages)).getName().func_150254_d(), 170).size())) {
                ++pageIndex;
                continue;
            }
            page.add(toAddNode);
            ++addedPages;
        }
        while (this.searchPageOffset > 0 && this.searchPageOffset >= this.searchResultPageIndex.size()) {
            --this.searchPageOffset;
        }
    }

    @Override
    protected void mouseDragTick(double mouseX, double mouseY, double mouseDiffX, double mouseDiffY, double mouseOffsetX, double mouseOffsetY) {
        super.mouseDragTick(mouseX, mouseY, mouseDiffX, mouseDiffY, mouseOffsetX, mouseOffsetY);
        if (this.inProgressView()) {
            progressionRenderer.moveMouse((float)mouseDiffX, (float)mouseDiffY);
        }
    }

    @Override
    protected void mouseDragStop(double mouseX, double mouseY, double mouseDiffX, double mouseDiffY) {
        super.mouseDragStop(mouseX, mouseY, mouseDiffX, mouseDiffY);
        if (this.inProgressView()) {
            progressionRenderer.applyMovedMouseOffset();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.inProgressView()) {
            if (scroll < 0.0) {
                progressionRenderer.handleZoomOut();
                return true;
            }
            if (scroll > 0.0) {
                progressionRenderer.handleZoomIn((float)mouseX, (float)mouseY);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton != 0) {
            return false;
        }
        if (this.handleBookmarkClick(mouseX, mouseY)) {
            return true;
        }
        if (this.inProgressView()) {
            return progressionRenderer.propagateClick((float)mouseX, (float)mouseY);
        }
        if (this.searchPrevRct != null && this.searchPrevRct.contains(mouseX, mouseY)) {
            --this.searchPageOffset;
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.searchNextRct != null && this.searchNextRct.contains(mouseX, mouseY)) {
            ++this.searchPageOffset;
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.searchHoverNode != null) {
            this.searchTextEntry.setText("");
            Minecraft.func_71410_x().func_147108_a((Screen)new ScreenJournalPages(this, this.searchHoverNode));
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return true;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.searchTextEntry.keyTyped(key)) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char charCode, int keyModifiers) {
        if (this.searchTextEntry.charTyped(charCode)) {
            return true;
        }
        return super.charTyped(charCode, keyModifiers);
    }
}

