/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.overlay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.overlay.ScreenJournalOverlay;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeMap;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeInterpreter;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeReader;
import hellfirepvp.astralsorcery.common.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.perk.type.vanilla.VanillaPerkAttributeType;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.LogicalSide;

public class ScreenJournalOverlayPerkStatistics
extends ScreenJournalOverlay {
    private static final int HEADER_WIDTH = 190;
    private static final int DEFAULT_WIDTH = 175;
    private final List<PerkStatistic> statistics = new LinkedList<PerkStatistic>();
    private int nameStrWidth = -1;
    private int valueStrWidth = -1;
    private int suffixStrWidth = -1;

    public ScreenJournalOverlayPerkStatistics(ScreenJournal origin) {
        super((ITextComponent)new TranslationTextComponent("screen.astralsorcery.tome.perks.stats", new Object[0]), origin);
    }

    @Override
    protected void init() {
        super.init();
        this.statistics.clear();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        PerkAttributeInterpreter interpreter = PerkAttributeInterpreter.defaultInterpreter((PlayerEntity)player);
        RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValues().stream().filter(t -> t instanceof VanillaPerkAttributeType).forEach(arg_0 -> ScreenJournalOverlayPerkStatistics.lambda$init$1((PlayerEntity)player, arg_0));
        for (PerkAttributeType type : RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValues()) {
            PerkStatistic strPerkStat;
            if (!type.hasTypeApplied((PlayerEntity)player, LogicalSide.CLIENT) || (strPerkStat = interpreter.getValue(type)) == null) continue;
            this.statistics.add(strPerkStat);
        }
        this.statistics.sort(Comparator.comparing(perkStatistic -> I18n.func_135052_a((String)perkStatistic.getUnlocPerkTypeName(), (Object[])new Object[0])));
    }

    @Override
    public void render(int mouseX, int mouseY, float pTicks) {
        super.render(mouseX, mouseY, pTicks);
        int width = 275;
        int height = 344;
        this.changeZLevel(150);
        TexturesAS.TEX_GUI_PARCHMENT_BLANK.bindTexture();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderingGuiUtils.drawRect(this.guiLeft + this.guiWidth / 2 - width / 2, this.guiTop + this.guiHeight / 2 - height / 2, this.getGuiZLevel(), width, height);
        RenderSystem.disableBlend();
        this.changeZLevel(-150);
        this.drawHeader();
        this.drawPageText(mouseX, mouseY);
    }

    private void drawHeader() {
        String locTitle = I18n.func_135052_a((String)"perk.reader.astralsorcery.gui", (Object[])new Object[0]);
        List split = this.font.func_78271_c(locTitle, MathHelper.func_76128_c((double)135.71428571428572));
        int step = 14;
        int offsetTop = this.guiTop + 15 - split.size() * step / 2;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)offsetTop, (double)0.0);
        for (int i = 0; i < split.size(); ++i) {
            String s = (String)split.get(i);
            double offsetLeft = (double)(this.width / 2) - (double)this.font.func_78256_a(s) * 1.4 / 2.0;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)offsetLeft, (double)(i * step), (double)0.0);
            RenderSystem.scaled((double)1.4, (double)1.4, (double)1.4);
            RenderingDrawUtils.renderStringAtCurrentPos(this.font, s, -298634445);
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
    }

    private void drawPageText(int mouseX, int mouseY) {
        if (this.nameStrWidth == -1 || this.valueStrWidth == -1 || this.suffixStrWidth == -1) {
            this.buildDisplayWidth();
        }
        HashMap valueStrMap = Maps.newHashMap();
        int offsetY = this.guiTop + 40;
        int offsetX = this.guiLeft + this.guiWidth / 2 - 87;
        int line = 0;
        for (PerkStatistic stat : this.statistics) {
            String statName = I18n.func_135052_a((String)stat.getUnlocPerkTypeName(), (Object[])new Object[0]);
            List split = this.font.func_78271_c(statName, MathHelper.func_76141_d((float)126.666664f));
            int additionalLines = Math.max(split.size(), 0);
            for (int i = 0; i < split.size(); ++i) {
                String statPart = (String)split.get(i);
                int drawX = offsetX;
                if (i > 0) {
                    drawX += 10;
                }
                RenderingDrawUtils.renderStringAtPos(drawX, offsetY + (line + i) * 10, this.getGuiZLevel(), this.font, statPart, -298634445, false);
            }
            RenderingDrawUtils.renderStringAtPos(offsetX + this.nameStrWidth, offsetY + line * 10, this.getGuiZLevel(), this.font, stat.getPerkValue(), -298634445, false);
            int strLength = this.font.func_78256_a(stat.getPerkValue());
            Rectangle rctValue = new Rectangle(offsetX + this.nameStrWidth, offsetY + line * 10, strLength, 8);
            valueStrMap.put(rctValue, stat);
            line += additionalLines;
            if (stat.getSuffix().isEmpty()) continue;
            RenderingDrawUtils.renderStringAtPos(offsetX + 25, offsetY + line * 10, this.getGuiZLevel(), this.font, stat.getSuffix(), -298634445, false);
            ++line;
        }
        for (Rectangle rct : valueStrMap.keySet()) {
            if (!rct.contains(mouseX, mouseY)) continue;
            PerkStatistic stat = (PerkStatistic)valueStrMap.get(rct);
            this.drawCalculationDescription(rct.x + rct.width + 2, rct.y + 15, stat);
        }
    }

    private void drawCalculationDescription(int x, int y, PerkStatistic stat) {
        PerkAttributeType type = stat.getType();
        PerkAttributeReader reader = type.getReader();
        if (reader == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        PerkAttributeMap attrMap = PerkAttributeHelper.getOrCreateMap((PlayerEntity)player, LogicalSide.CLIENT);
        ArrayList information = Lists.newArrayList();
        information.add(I18n.func_135052_a((String)"perk.reader.astralsorcery.description.head", (Object[])new Object[]{PerkAttributeReader.formatDecimal(reader.getDefaultValue(attrMap, (PlayerEntity)player, LogicalSide.CLIENT))}));
        information.add(I18n.func_135052_a((String)"perk.reader.astralsorcery.description.addition", (Object[])new Object[]{PerkAttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (PlayerEntity)player, LogicalSide.CLIENT, ModifierType.ADDITION) - 1.0)}));
        information.add(I18n.func_135052_a((String)"perk.reader.astralsorcery.description.increase", (Object[])new Object[]{PerkAttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (PlayerEntity)player, LogicalSide.CLIENT, ModifierType.ADDED_MULTIPLY))}));
        information.add(I18n.func_135052_a((String)"perk.reader.astralsorcery.description.moreless", (Object[])new Object[]{PerkAttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (PlayerEntity)player, LogicalSide.CLIENT, ModifierType.STACKING_MULTIPLY))}));
        if (!stat.getSuffix().isEmpty() || !stat.getPostProcessInfo().isEmpty()) {
            information.add("");
        }
        if (!stat.getSuffix().isEmpty()) {
            information.add(stat.getSuffix());
        }
        if (!stat.getPostProcessInfo().isEmpty()) {
            information.add(stat.getPostProcessInfo());
        }
        RenderingDrawUtils.renderBlueTooltipString(x, y, this.getGuiZLevel(), information, this.font, false);
    }

    private void buildDisplayWidth() {
        this.nameStrWidth = -1;
        this.valueStrWidth = -1;
        this.suffixStrWidth = -1;
        for (PerkStatistic stat : this.statistics) {
            int nameWidth = Math.min(this.font.func_78256_a(I18n.func_135052_a((String)stat.getUnlocPerkTypeName(), (Object[])new Object[0])), 126);
            int valueWidth = this.font.func_78256_a(stat.getPerkValue());
            int suffixWidth = this.font.func_78256_a(stat.getSuffix());
            if (nameWidth > this.nameStrWidth) {
                this.nameStrWidth = nameWidth;
            }
            if (valueWidth > this.valueStrWidth) {
                this.valueStrWidth = valueWidth;
            }
            if (suffixWidth <= this.suffixStrWidth) continue;
            this.suffixStrWidth = suffixWidth;
        }
        this.nameStrWidth += 6;
        this.valueStrWidth += 6;
        this.suffixStrWidth += 6;
    }

    private static /* synthetic */ void lambda$init$1(PlayerEntity player, PerkAttributeType t) {
        ((VanillaPerkAttributeType)((Object)t)).refreshAttribute(player);
    }
}

