/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.page;

import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageRecipeTemplate;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class RenderPageAltarRecipe
extends RenderPageRecipeTemplate {
    private final SimpleAltarRecipe recipe;
    private final AbstractRenderableTexture gridTexture;

    public RenderPageAltarRecipe(@Nullable ResearchNode node, int nodePage, SimpleAltarRecipe recipe) {
        super(node, nodePage);
        this.recipe = recipe;
        this.gridTexture = this.getGridTexture(recipe);
    }

    private AbstractRenderableTexture getGridTexture(SimpleAltarRecipe recipe) {
        switch (recipe.getAltarType()) {
            case DISCOVERY: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T1;
            }
            case ATTUNEMENT: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T2;
            }
            case CONSTELLATION: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T3;
            }
            case RADIANCE: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T4;
            }
        }
        return TexturesAS.TEX_GUI_BOOK_GRID_T4;
    }

    @Override
    public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        this.clearFrameRectangles();
        this.renderRecipeGrid(offsetX, offsetY, zLevel, this.gridTexture);
        this.renderExpectedItemStackOutput(offsetX + 78.0f, offsetY + 25.0f, zLevel, 1.4f, this.recipe.getOutputForRender(Collections.emptyList()));
        this.renderInfoStar(offsetX, offsetY, zLevel, pTicks);
        this.renderRequiredConstellation(offsetX, offsetY, zLevel, this.recipe.getFocusConstellation());
        int widthShift = (5 - this.recipe.getInputs().getWidth()) / 2;
        int heightShift = (5 - this.recipe.getInputs().getHeight()) / 2;
        AltarType type = this.recipe.getAltarType();
        float recipeX = offsetX + 30.0f;
        float recipeY = offsetY + 78.0f;
        for (int xx = 0; xx < 5; ++xx) {
            for (int yy = 0; yy < 5; ++yy) {
                int recipeIndex;
                int slot = xx + yy * 5;
                if (!type.hasSlot(slot) || (recipeIndex = xx - widthShift + (yy - heightShift) * 5) < 0 || recipeIndex >= 25) continue;
                float renderX = recipeX + (float)(25 * xx);
                float renderY = recipeY + (float)(25 * yy);
                this.renderExpectedIngredientInput(renderX, renderY, zLevel, (double)1.1f, (long)(recipeIndex * 20), this.recipe.getInputs().getIngredient(recipeIndex));
            }
        }
        this.renderExpectedRelayInputs(offsetX, offsetY, zLevel, this.recipe);
    }

    @Override
    public boolean propagateMouseClick(double mouseX, double mouseZ) {
        return this.handleRecipeNameCopyClick(mouseX, mouseZ, this.recipe) || this.handleBookLookupClick(mouseX, mouseZ);
    }

    @Override
    public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        this.renderHoverTooltips(mouseX, mouseY, zLevel, this.recipe.func_199560_c());
        this.renderInfoStarTooltips(offsetX, offsetY, zLevel, mouseX, mouseY, toolTip -> {
            this.addAltarRecipeTooltip(this.recipe, (List<ITextComponent>)toolTip);
            this.addConstellationInfoTooltip(this.recipe.getFocusConstellation(), (List<ITextComponent>)toolTip);
        });
    }
}

