/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.observerlib.api.client.StructureRenderer;
import hellfirepvp.observerlib.api.structure.Structure;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class RenderPageStructure
extends RenderablePage {
    private final StructureRenderer structureRenderer;
    private final Structure structure;
    private final Vector3 shift;
    private final List<Tuple<ItemStack, ITextComponent>> contentStacks;
    private final ITextComponent name;
    private Optional<Integer> drawSlice = Optional.empty();
    private Rectangle switchView = null;
    private Rectangle sliceUp = null;
    private Rectangle sliceDown = null;
    private long totalRenderFrame = 0L;

    public RenderPageStructure(@Nullable ResearchNode node, int nodePage, Structure structure, @Nullable ITextComponent name, @Nonnull Vector3 shift) {
        super(node, nodePage);
        this.structure = structure;
        this.structureRenderer = new StructureRenderer(this.structure).setIsolateIndividualBlock(true);
        this.name = name;
        this.shift = shift;
        this.contentStacks = MapStream.ofKeys(structure.getAsStacks((IBlockReader)this.structureRenderer.getRenderWorld(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g), stack -> new StringTextComponent(stack.func_190916_E() + "x ").func_150257_a(stack.func_200301_q())).toTupleList();
    }

    @Override
    public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        ++this.totalRenderFrame;
        this.renderStructure(offsetX, offsetY, pTicks);
        float shift = this.renderSizeDescription(offsetX, offsetY + 5.0f, zLevel);
        if (this.name != null) {
            this.renderHeadline(offsetX + shift, offsetY + 5.0f, zLevel, this.name);
        }
    }

    private void renderHeadline(float offsetX, float offsetY, float zLevel, ITextComponent title) {
        float scale = 1.3f;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)offsetX, (double)offsetY, (double)0.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.disableDepthTest();
        RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, zLevel, null, title.func_150254_d(), 0xDDDDDD, true);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
    }

    private float renderSizeDescription(float offsetX, float offsetY, float zLevel) {
        Vector3 size = new Vector3(this.structure.getMaximumOffset()).subtract(this.structure.getMinimumOffset());
        FontRenderer fr = RenderablePage.getFontRenderer();
        float scale = 1.3f;
        String desc = (int)size.getX() + " - " + (int)size.getY() + " - " + (int)size.getZ();
        float length = (float)fr.func_78256_a(desc) * scale;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)offsetX, (double)offsetY, (double)0.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.disableDepthTest();
        RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, zLevel, fr, desc, 0xDDDDDD, true);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
        return length + 8.0f;
    }

    private void renderStructure(float offsetX, float offsetY, float pTicks) {
        Point2D.Double renderOffset = this.renderOffset(offsetX + 8.0f, offsetY);
        this.structureRenderer.render3DSliceGUI(new MatrixStack(), renderOffset.x + this.shift.getX(), renderOffset.y + this.shift.getY(), pTicks, this.drawSlice);
    }

    private Point2D.Double renderOffset(float stdPageOffsetX, float stdPageOffsetY) {
        return new Point2D.Double((double)stdPageOffsetX + 78.75, (double)stdPageOffsetY + 132.0);
    }

    @Override
    public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        MatrixStack renderStack = new MatrixStack();
        renderStack.func_227861_a_((double)(offsetX + 160.0f), (double)(offsetY + 10.0f), (double)zLevel);
        Rectangle rect = RenderingDrawUtils.drawInfoStar(renderStack, IDrawRenderTypeBuffer.defaultBuffer(), 15.0f, pTicks);
        rect.translate((int)(offsetX + 160.0f), (int)(offsetY + 10.0f));
        if (rect.contains(mouseX, mouseY)) {
            RenderingDrawUtils.renderBlueTooltip(offsetX + 160.0f, offsetY + 10.0f, zLevel + 150.0f, this.contentStacks, RenderablePage.getFontRenderer(), false);
        }
    }

    @Override
    public boolean propagateMouseDrag(double mouseDX, double mouseDZ) {
        this.structureRenderer.rotateFromMouseDrag((float)mouseDX, (float)mouseDZ);
        return true;
    }

    @Override
    public boolean propagateMouseClick(double mouseX, double mouseZ) {
        if (this.switchView != null && this.switchView.contains(mouseX, mouseZ)) {
            this.drawSlice = this.drawSlice.isPresent() ? Optional.empty() : Optional.of(this.structureRenderer.getDefaultSlice());
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.sliceUp != null && this.drawSlice.isPresent() && this.sliceUp.contains(mouseX, mouseZ)) {
            this.drawSlice = Optional.of(this.drawSlice.get() + 1);
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.sliceDown != null && this.drawSlice.isPresent() && this.sliceDown.contains(mouseX, mouseZ)) {
            this.drawSlice = Optional.of(this.drawSlice.get() - 1);
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

