/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.progression;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.screen.base.WidthHeightScreen;
import hellfirepvp.astralsorcery.client.screen.helper.ScalingPoint;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalPages;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalProgression;
import hellfirepvp.astralsorcery.client.screen.journal.progression.ProgressionSizeHandler;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class ScreenJournalClusterRenderer {
    private ProgressionSizeHandler progressionSizeHandler;
    private ResearchProgression progression;
    private ScalingPoint mousePointScaled;
    private ScalingPoint previousMousePointScaled;
    private int renderOffsetX;
    private int renderOffsetY;
    private int renderGuiHeight;
    private int renderGuiWidth;
    private boolean hasPrevOffset = false;
    private float alpha = 1.0f;
    private Map<Rectangle, ResearchNode> clickableNodes = new HashMap<Rectangle, ResearchNode>();

    public ScreenJournalClusterRenderer(ResearchProgression progression, int guiHeight, int guiWidth, int guiLeft, int guiTop) {
        this.progression = progression;
        this.progressionSizeHandler = new ProgressionSizeHandler(progression);
        this.progressionSizeHandler.setMaxScale(1.2f);
        this.progressionSizeHandler.setMinScale(0.1f);
        this.progressionSizeHandler.setScaleSpeed(0.044999998f);
        this.progressionSizeHandler.updateSize();
        this.progressionSizeHandler.forceScaleTo(0.1f);
        this.mousePointScaled = ScalingPoint.createPoint(0.0f, 0.0f, this.progressionSizeHandler.getScalingFactor(), false);
        this.centerMouse();
        this.applyMovedMouseOffset();
        this.renderOffsetX = guiLeft;
        this.renderOffsetY = guiTop;
        this.renderGuiHeight = guiHeight;
        this.renderGuiWidth = guiWidth;
    }

    public boolean propagateClick(ScreenJournalProgression parent, double mouseX, double mouseY) {
        Rectangle frame = new Rectangle(this.renderOffsetX, this.renderOffsetY, this.renderGuiWidth, this.renderGuiHeight);
        if (frame.contains(mouseX, mouseY)) {
            for (Rectangle r : this.clickableNodes.keySet()) {
                if (!r.contains(mouseX, mouseY)) continue;
                ResearchNode clicked = this.clickableNodes.get(r);
                Minecraft.func_71410_x().func_147108_a((Screen)new ScreenJournalPages(parent, clicked));
                return true;
            }
        }
        return false;
    }

    public void drawMouseHighlight(float zLevel, int mouseX, int mouseY) {
        Rectangle frame = new Rectangle(this.renderOffsetX, this.renderOffsetY, this.renderGuiWidth, this.renderGuiHeight);
        if (frame.contains(mouseX, mouseY)) {
            for (Rectangle r : this.clickableNodes.keySet()) {
                if (!r.contains(mouseX, mouseY)) continue;
                String name = this.clickableNodes.get(r).getName().func_150254_d();
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)r.getX(), (double)r.getY(), (double)0.0);
                RenderSystem.scaled((double)this.progressionSizeHandler.getScalingFactor(), (double)this.progressionSizeHandler.getScalingFactor(), (double)this.progressionSizeHandler.getScalingFactor());
                RenderingDrawUtils.renderBlueTooltipString(0.0f, 0.0f, zLevel, Lists.newArrayList((Object[])new String[]{name}), Minecraft.func_71410_x().field_71466_p, false);
                RenderSystem.popMatrix();
            }
        }
    }

    public void centerMouse() {
        Point2D.Float center = this.progressionSizeHandler.getRelativeCenter();
        this.moveMouse(center.x, center.y);
    }

    public void moveMouse(float changedX, float changedY) {
        if (this.hasPrevOffset) {
            this.mousePointScaled.updateScaledPos(this.progressionSizeHandler.clampX(this.previousMousePointScaled.getScaledPosX() + changedX), this.progressionSizeHandler.clampY(this.previousMousePointScaled.getScaledPosY() + changedY), this.progressionSizeHandler.getScalingFactor());
        } else {
            this.mousePointScaled.updateScaledPos(this.progressionSizeHandler.clampX(changedX), this.progressionSizeHandler.clampY(changedY), this.progressionSizeHandler.getScalingFactor());
        }
    }

    public void applyMovedMouseOffset() {
        this.previousMousePointScaled = ScalingPoint.createPoint(this.mousePointScaled.getScaledPosX(), this.mousePointScaled.getScaledPosY(), this.progressionSizeHandler.getScalingFactor(), true);
        this.hasPrevOffset = true;
    }

    public void handleZoomOut() {
        this.progressionSizeHandler.handleZoomOut();
        this.rescale(this.progressionSizeHandler.getScalingFactor());
    }

    public void handleZoomIn() {
        this.progressionSizeHandler.handleZoomIn();
        this.rescale(this.progressionSizeHandler.getScalingFactor());
    }

    public float getMouseX() {
        return this.mousePointScaled.getPosX();
    }

    public float getMouseY() {
        return this.mousePointScaled.getPosY();
    }

    private void rescale(float newScale) {
        this.mousePointScaled.rescale(newScale);
        if (this.previousMousePointScaled != null) {
            this.previousMousePointScaled.rescale(newScale);
        }
        this.moveMouse(0.0f, 0.0f);
    }

    public void drawClusterScreen(WidthHeightScreen parentGui, float zLevel) {
        this.clickableNodes.clear();
        this.drawNodesAndConnections(parentGui, zLevel);
    }

    private void drawNodesAndConnections(WidthHeightScreen parentGui, float zLevel) {
        this.alpha = this.progressionSizeHandler.getScalingFactor();
        this.alpha -= 0.25f;
        this.alpha /= 0.75f;
        this.alpha = MathHelper.func_76131_a((float)this.alpha, (float)0.0f, (float)1.0f);
        HashMap<ResearchNode, Point2D.Float> displayPositions = new HashMap<ResearchNode, Point2D.Float>();
        for (ResearchNode node2 : this.progression.getResearchNodes()) {
            if (!node2.canSee(ResearchHelper.getClientProgress())) continue;
            Point2D.Float from = this.progressionSizeHandler.scalePointToGui(parentGui, this.mousePointScaled, new Point2D.Float(node2.renderPosX, node2.renderPosZ));
            for (ResearchNode target : node2.getConnectionsTo()) {
                Point2D.Float to = this.progressionSizeHandler.scalePointToGui(parentGui, this.mousePointScaled, new Point2D.Float(target.renderPosX, target.renderPosZ));
                this.drawConnection(from.x, from.y, to.x, to.y, zLevel);
            }
            displayPositions.put(node2, from);
        }
        displayPositions.forEach((node, pos) -> this.renderNodeToGUI((ResearchNode)node, (Point2D.Float)pos, zLevel));
    }

    private void renderNodeToGUI(ResearchNode node, Point2D.Float offset, float zLevel) {
        float zoomedWH = this.progressionSizeHandler.getZoomedWHNode();
        float offsetX = offset.x - zoomedWH / 2.0f;
        float offsetY = offset.y - zoomedWH / 2.0f;
        node.getBackgroundTexture().resolve().bindTexture();
        if ((double)this.progressionSizeHandler.getScalingFactor() >= 0.7) {
            this.clickableNodes.put(new Rectangle(MathHelper.func_76141_d((float)offsetX), MathHelper.func_76141_d((float)offsetY), MathHelper.func_76141_d((float)zoomedWH), MathHelper.func_76141_d((float)zoomedWH)), node);
        }
        this.drawResearchItemBackground(zoomedWH, offsetX, offsetY, zLevel);
        float pxWH = this.progressionSizeHandler.getZoomedWHNode() / 16.0f;
        switch (node.getNodeRenderType()) {
            case ITEMSTACK: {
                MatrixStack renderStack = new MatrixStack();
                renderStack.func_227861_a_((double)offsetX, (double)offsetY, 0.0);
                renderStack.func_227862_a_(this.progressionSizeHandler.getScalingFactor(), this.progressionSizeHandler.getScalingFactor(), this.progressionSizeHandler.getScalingFactor());
                renderStack.func_227861_a_(3.0, 3.0, 3.0);
                renderStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                renderStack.func_227861_a_(0.0, 0.0, 100.0);
                RenderingUtils.renderTranslucentItemStackModelGUI(node.getRenderItemStack(ClientScheduler.getClientTick()), renderStack, Color.WHITE, Blending.DEFAULT, MathHelper.func_76125_a((int)((int)(this.alpha * 255.0f)), (int)0, (int)255));
                break;
            }
            case TEXTURE_SPRITE: {
                Color col = node.getTextureColorHint();
                float r = (float)col.getRed() / 255.0f * this.alpha;
                float g = (float)col.getGreen() / 255.0f * this.alpha;
                float b = (float)col.getBlue() / 255.0f * this.alpha;
                float a = (float)col.getAlpha() / 255.0f * this.alpha;
                SpriteSheetResource res = node.getSpriteTexture().resolveSprite();
                res.getResource().bindTexture();
                Tuple<Float, Float> uvTexture = res.getUVOffset(ClientScheduler.getClientTick());
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)offsetX, (double)offsetY, (double)0.0);
                RenderSystem.enableTexture();
                RenderSystem.enableBlend();
                Blending.DEFAULT.apply();
                RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
                    buf.func_225582_a_((double)pxWH, (double)(zoomedWH - pxWH), (double)zLevel).func_227885_a_(r, g, b, a).func_225583_a_(((Float)uvTexture.func_76341_a()).floatValue(), ((Float)uvTexture.func_76340_b()).floatValue() + res.getVLength()).func_181675_d();
                    buf.func_225582_a_((double)(zoomedWH - pxWH), (double)(zoomedWH - pxWH), (double)zLevel).func_227885_a_(r, g, b, a).func_225583_a_(((Float)uvTexture.func_76341_a()).floatValue() + res.getULength(), ((Float)uvTexture.func_76340_b()).floatValue() + res.getVLength()).func_181675_d();
                    buf.func_225582_a_((double)(zoomedWH - pxWH), (double)pxWH, (double)zLevel).func_227885_a_(r, g, b, a).func_225583_a_(((Float)uvTexture.func_76341_a()).floatValue() + res.getULength(), ((Float)uvTexture.func_76340_b()).floatValue()).func_181675_d();
                    buf.func_225582_a_((double)pxWH, (double)pxWH, (double)zLevel).func_227885_a_(r, g, b, a).func_225583_a_(((Float)uvTexture.func_76341_a()).floatValue(), ((Float)uvTexture.func_76340_b()).floatValue()).func_181675_d();
                });
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.disableTexture();
                RenderSystem.popMatrix();
                break;
            }
        }
    }

    private void drawConnection(float originX, float originY, float targetX, float targetY, float zLevel) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        RenderSystem.lineWidth((float)4.0f);
        long clientTicks = ClientScheduler.getClientTick();
        Vector3 origin = new Vector3(originX, originY, 0.0f);
        Vector3 line = origin.vectorFromHereTo(targetX, targetY, 0.0);
        int segments = (int)Math.ceil(line.length() / 1.0);
        int activeSegment = (int)(clientTicks % (long)segments);
        Vector3 segmentIter = line.divide(segments);
        RenderingUtils.draw(3, DefaultVertexFormats.field_181706_f, buf -> {
            for (int i = segments; i >= 0; --i) {
                double lx = origin.getX();
                double ly = origin.getY();
                origin.add(segmentIter);
                float brightness = 0.6f;
                this.drawLinePart((IVertexBuilder)buf, lx, ly, origin.getX(), origin.getY(), zLevel, brightness += 0.4f * this.evaluateBrightness(i, activeSegment));
            }
        });
        RenderSystem.lineWidth((float)2.0f);
        GL11.glDisable((int)2848);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private void drawLinePart(IVertexBuilder buf, double lx, double ly, double hx, double hy, float zLevel, float brightness) {
        buf.func_225582_a_(lx, ly, (double)zLevel).func_227885_a_(brightness * this.alpha, brightness * this.alpha, brightness * this.alpha, 0.4f * this.alpha).func_181675_d();
        buf.func_225582_a_(hx, hy, (double)zLevel).func_227885_a_(brightness * this.alpha, brightness * this.alpha, brightness * this.alpha, 0.4f * this.alpha).func_181675_d();
    }

    private float evaluateBrightness(int segment, int activeSegment) {
        if (segment == activeSegment) {
            return 1.0f;
        }
        float res = (float)(10 - Math.abs(activeSegment - segment)) / 10.0f;
        return Math.max(0.0f, res);
    }

    private void drawResearchItemBackground(double zoomedWH, double xAdd, double yAdd, float zLevel) {
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            buf.func_225582_a_(xAdd, yAdd + zoomedWH, (double)zLevel).func_227885_a_(this.alpha, this.alpha, this.alpha, this.alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_225582_a_(xAdd + zoomedWH, yAdd + zoomedWH, (double)zLevel).func_227885_a_(this.alpha, this.alpha, this.alpha, this.alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_225582_a_(xAdd + zoomedWH, yAdd, (double)zLevel).func_227885_a_(this.alpha, this.alpha, this.alpha, this.alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_225582_a_(xAdd, yAdd, (double)zLevel).func_227885_a_(this.alpha, this.alpha, this.alpha, this.alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
        RenderSystem.disableBlend();
        RenderSystem.disableTexture();
    }
}

