/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.sky;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.data.config.entry.RenderingConfig;
import hellfirepvp.astralsorcery.client.sky.astral.AstralSkyRenderer;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.client.IRenderHandler;

public class ChainingSkyRenderer
implements IRenderHandler {
    private IRenderHandler existingSkyRenderer;

    public ChainingSkyRenderer(IRenderHandler existingSkyRenderer) {
        this.existingSkyRenderer = existingSkyRenderer;
    }

    public void render(int ticks, float partialTicks, ClientWorld world, Minecraft mc) {
        EventFlags.SKY_RENDERING.executeWithFlag(() -> {
            MatrixStack renderStack = new MatrixStack();
            ActiveRenderInfo ari = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(0.0f));
            renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(ari.func_216777_e()));
            renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ari.func_216778_f() + 180.0f));
            int dimId = world.func_201675_m().func_186058_p().func_186068_a();
            if (world.field_73011_w.func_76569_d()) {
                if (((List)RenderingConfig.CONFIG.weakSkyRenders.get()).contains(dimId)) {
                    if (this.existingSkyRenderer != null) {
                        this.existingSkyRenderer.render(ticks, partialTicks, world, mc);
                    } else {
                        IRenderHandler existing = world.func_201675_m().getSkyRenderer();
                        world.func_201675_m().setSkyRenderer(null);
                        Minecraft.func_71410_x().field_71438_f.func_228424_a_(renderStack, partialTicks);
                        world.func_201675_m().setSkyRenderer(existing);
                    }
                    this.renderConstellations(world, renderStack, partialTicks);
                } else {
                    AstralSkyRenderer.INSTANCE.render(ticks, partialTicks, world, mc);
                }
            } else {
                IRenderHandler existing = world.func_201675_m().getSkyRenderer();
                world.func_201675_m().setSkyRenderer(null);
                Minecraft.func_71410_x().field_71438_f.func_228424_a_(renderStack, partialTicks);
                world.func_201675_m().setSkyRenderer(existing);
            }
        });
    }

    private void renderConstellations(ClientWorld world, MatrixStack renderStack, float pTicks) {
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        Blending.ADDITIVE_ALPHA.apply();
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)false);
        float alphaSubRain = 1.0f - world.func_72867_j(pTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaSubRain);
        renderStack.func_227860_a_();
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        AstralSkyRenderer.renderConstellationsSky(world, renderStack, pTicks);
        renderStack.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableTexture();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }
}

