/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXCube;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileAreaOfInfluence;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.awt.Color;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;

public class AreaOfInfluencePreview
implements ITickHandler {
    public static final AreaOfInfluencePreview INSTANCE = new AreaOfInfluencePreview();
    private static final int MAX_LIFE = 40;
    private static final float alphaTick = 0.025f;
    private static final float sizeCube1 = 0.9f;
    private static final float sizeCube2 = 1.05f;
    private DimensionType tileDimension = null;
    private BlockPos tilePosition = null;
    private FXCube effect1 = null;
    private FXCube effect2 = null;

    private AreaOfInfluencePreview() {
    }

    public void show(TileAreaOfInfluence aoeTile) {
        if (!(aoeTile instanceof TileEntity)) {
            return;
        }
        this.tileDimension = aoeTile.getDimensionType();
        this.tilePosition = aoeTile.getEffectOriginPosition();
    }

    public void clearClient() {
        this.tileDimension = null;
        this.tilePosition = null;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        if (this.tileDimension == null || this.tilePosition == null) {
            this.removeEffects();
            return;
        }
        ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
        if (clientWorld == null) {
            this.clearClient();
            this.removeEffects();
            return;
        }
        DimensionType clientDimType = clientWorld.func_201675_m().func_186058_p();
        if (!clientDimType.equals(this.tileDimension)) {
            this.clearClient();
            this.removeEffects();
            return;
        }
        TileAreaOfInfluence aoeTile = MiscUtils.getTileAt((IBlockReader)clientWorld, this.tilePosition, TileAreaOfInfluence.class, true);
        if (aoeTile != null && aoeTile.providesEffect() && this.shouldContinueEffect(aoeTile)) {
            this.effect1 = this.uptickEffect(this.effect1, 0.9f, aoeTile);
            this.effect2 = this.uptickEffect(this.effect2, 1.05f, aoeTile);
        } else {
            this.effect1 = this.downtickEffect(this.effect1, 0.9f, aoeTile);
            this.effect2 = this.downtickEffect(this.effect2, 1.05f, aoeTile);
            if (this.effect1 == null && this.effect2 == null) {
                this.clearClient();
            }
        }
    }

    private boolean shouldContinueEffect(TileAreaOfInfluence aoeTile) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        float effectRadius = aoeTile.getRadius();
        if (effectRadius <= 0.0f) {
            return false;
        }
        Vector3 offset = aoeTile.getEffectPosition();
        double distance = offset.distance((Entity)Minecraft.func_71410_x().field_71439_g);
        if (distance > (double)(effectRadius * 3.0f)) {
            return false;
        }
        return distance <= 48.0;
    }

    private FXCube downtickEffect(@Nullable FXCube cube, float sizeMultiplier, @Nullable TileAreaOfInfluence aoeTile) {
        if (cube != null && !cube.isRemoved()) {
            if (aoeTile != null) {
                this.updateEffect(cube, sizeMultiplier, aoeTile);
            }
            cube.setAlphaMultiplier(MathHelper.func_76131_a((float)(cube.getAlphaMultiplier() - 0.025f), (float)0.0f, (float)0.75f));
            if (!this.canRefresh(cube)) {
                cube = null;
            }
        }
        return cube;
    }

    private FXCube uptickEffect(@Nullable FXCube cube, float sizeMultiplier, TileAreaOfInfluence aoeTile) {
        if (cube != null) {
            if (cube.isRemoved()) {
                EffectHelper.refresh(cube, EffectTemplatesAS.CUBE_AREA_OF_EFFECT);
            }
            cube.setAlphaMultiplier(MathHelper.func_76131_a((float)(cube.getAlphaMultiplier() + 0.025f), (float)0.0f, (float)0.75f));
            this.updateEffect(cube, sizeMultiplier, aoeTile);
        } else {
            cube = this.createCube(sizeMultiplier, aoeTile);
        }
        return cube;
    }

    private void updateEffect(FXCube cube, float sizeMultiplier, TileAreaOfInfluence aoeTile) {
        Color c = aoeTile.getEffectColor();
        if (c != null) {
            cube.color(VFXColorFunction.constant(c));
        } else {
            cube.color(VFXColorFunction.WHITE);
        }
        cube.setScaleMultiplier(aoeTile.getRadius() * sizeMultiplier);
        cube.setPosition(aoeTile.getEffectPosition());
    }

    private FXCube createCube(float sizeMultiplier, TileAreaOfInfluence aoeTile) {
        FXCube cube = (FXCube)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXCube)EffectHelper.of(EffectTemplatesAS.CUBE_AREA_OF_EFFECT).spawn(aoeTile.getEffectPosition())).tumble().setTumbleIntensityMultiplier(0.06f).setAlphaMultiplier(0.05f)).alpha((fx, alpha, pTicks) -> alpha)).color(VFXColorFunction.WHITE)).refresh(fx -> this.canRefresh((FXCube)fx));
        this.updateEffect(cube, sizeMultiplier, aoeTile);
        return cube;
    }

    private void removeEffects() {
        if (this.effect1 != null) {
            this.effect1.setAlphaMultiplier(0.0f);
            this.effect1 = null;
        }
        if (this.effect2 != null) {
            this.effect2.setAlphaMultiplier(0.0f);
            this.effect2 = null;
        }
    }

    private boolean canRefresh(FXCube cube) {
        return (float)cube.getAlpha(1.0f) > 0.0f;
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Area of Effect Preview";
    }
}

