/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.RenderTypesAS;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.LightmapUtil;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.draw.RenderInfo;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class RenderingDrawUtils {
    private static final Random rand = new Random();

    public static void renderStringCentered(@Nullable FontRenderer fr, String str, int x, int y, float scale, int color) {
        if (fr == null) {
            fr = Minecraft.func_71410_x().field_71466_p;
        }
        float strLength = (float)fr.func_78256_a(str) * scale;
        float offsetLeft = (float)x - strLength;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)offsetLeft, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        RenderingDrawUtils.renderStringAtCurrentPos(fr, str, color);
        RenderSystem.popMatrix();
    }

    public static float renderStringAtCurrentPos(@Nullable FontRenderer fr, String str, int color) {
        return RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, 0.0f, fr, str, color, false);
    }

    public static float renderStringWithShadowAtCurrentPos(@Nullable FontRenderer fr, String str, int color) {
        return RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, 0.0f, fr, str, color, true);
    }

    public static float renderStringAtPos(float x, float y, float zLevel, @Nullable FontRenderer fr, String str, int color, boolean dropShadow) {
        if (fr == null) {
            fr = Minecraft.func_71410_x().field_71466_p;
        }
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack renderStack = new MatrixStack();
        renderStack.func_227861_a_((double)x, (double)y, (double)zLevel);
        int length = fr.func_228079_a_(str, 0.0f, 0.0f, color, dropShadow, renderStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, LightmapUtil.getPackedFullbrightCoords());
        buffer.func_228461_a_();
        return x + (float)length;
    }

    public static Rectangle drawInfoStar(MatrixStack renderStack, IDrawRenderTypeBuffer buffer, float widthHeightBase, float pTicks) {
        IVertexBuilder vb = buffer.getBuffer(RenderTypesAS.GUI_MISC_INFO_STAR);
        float tick = (float)ClientScheduler.getClientTick() + pTicks;
        float deg = tick * 2.0f % 360.0f;
        float wh = widthHeightBase - widthHeightBase / 6.0f * (MathHelper.func_76126_a((float)((float)Math.toRadians(tick * 4.0f % 360.0f))) + 1.0f);
        RenderingDrawUtils.drawInfoStarSingle(renderStack, vb, wh, Math.toRadians(deg));
        deg = (tick + 22.5f) * 2.0f % 360.0f;
        wh = widthHeightBase - widthHeightBase / 6.0f * (MathHelper.func_76126_a((float)((float)Math.toRadians((tick + 45.0f) * 4.0f % 360.0f))) + 1.0f);
        RenderingDrawUtils.drawInfoStarSingle(renderStack, vb, wh, Math.toRadians(deg));
        buffer.draw(RenderTypesAS.GUI_MISC_INFO_STAR);
        return new Rectangle(MathHelper.func_76141_d((float)(-widthHeightBase / 2.0f)), MathHelper.func_76141_d((float)(-widthHeightBase / 2.0f)), MathHelper.func_76141_d((float)widthHeightBase), MathHelper.func_76141_d((float)widthHeightBase));
    }

    private static void drawInfoStarSingle(MatrixStack renderStack, IVertexBuilder vb, float widthHeight, double deg) {
        Vector3 offset = new Vector3((double)(-widthHeight) / 2.0, (double)(-widthHeight) / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv01 = new Vector3((double)(-widthHeight) / 2.0, (double)widthHeight / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv11 = new Vector3((double)widthHeight / 2.0, (double)widthHeight / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv10 = new Vector3((double)widthHeight / 2.0, (double)(-widthHeight) / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        vb.func_227888_a_(matr, (float)uv01.getX(), (float)uv01.getY(), 0.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        vb.func_227888_a_(matr, (float)uv11.getX(), (float)uv11.getY(), 0.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        vb.func_227888_a_(matr, (float)uv10.getX(), (float)uv10.getY(), 0.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(matr, (float)offset.getX(), (float)offset.getY(), 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    public static void renderBlueTooltipString(float x, float y, float zLevel, List<String> tooltipData, FontRenderer fontRenderer, boolean isFirstLineHeadline) {
        List<Tuple<ItemStack, ITextComponent>> stackTooltip = MapStream.ofValues(tooltipData, t -> ItemStack.field_190927_a).mapValue(tip -> new StringTextComponent(tip)).toTupleList();
        RenderingDrawUtils.renderBlueTooltip(x, y, zLevel, stackTooltip, fontRenderer, isFirstLineHeadline);
    }

    public static void renderBlueTooltipComponents(float x, float y, float zLevel, List<ITextComponent> tooltipData, FontRenderer fontRenderer, boolean isFirstLineHeadline) {
        List<Tuple<ItemStack, ITextComponent>> stackTooltip = MapStream.ofValues(tooltipData, t -> ItemStack.field_190927_a).toTupleList();
        RenderingDrawUtils.renderBlueTooltip(x, y, zLevel, stackTooltip, fontRenderer, isFirstLineHeadline);
    }

    public static void renderBlueTooltip(float x, float y, float zLevel, List<Tuple<ItemStack, ITextComponent>> tooltipData, FontRenderer fontRenderer, boolean isFirstLineHeadline) {
        RenderingDrawUtils.renderTooltip(x, y, zLevel, tooltipData, -16777177, -16777148, Color.WHITE, fontRenderer, isFirstLineHeadline);
    }

    public static void renderBlueStackTooltip(float x, float y, float zLevel, List<Tuple<ItemStack, String>> tooltipData, FontRenderer fontRenderer, boolean isFirstLineHeadline) {
        List<Tuple<ItemStack, ITextComponent>> stackTooltip = MapStream.of(tooltipData).mapValue(str -> new StringTextComponent(str)).toTupleList();
        RenderingDrawUtils.renderTooltip(x, y, zLevel, stackTooltip, -16777177, -16777148, Color.WHITE, fontRenderer, isFirstLineHeadline);
    }

    public static void renderTooltip(float x, float y, float zLevel, List<Tuple<ItemStack, ITextComponent>> tooltipData, int color, int colorFade, Color strColor, FontRenderer fontRenderer, boolean isFirstLineHeadline) {
        int stackBoxSize = 18;
        if (!tooltipData.isEmpty()) {
            boolean anyItemFound = false;
            int maxWidth = 0;
            for (Tuple<ItemStack, ITextComponent> toolTip : tooltipData) {
                Object customFR = ((ItemStack)toolTip.func_76341_a()).func_77973_b().getFontRenderer((ItemStack)toolTip.func_76341_a());
                if (customFR == null) {
                    customFR = fontRenderer;
                }
                int n = customFR.func_78256_a(((ITextComponent)toolTip.func_76340_b()).func_150254_d());
                if (!((ItemStack)toolTip.func_76341_a()).func_190926_b()) {
                    anyItemFound = true;
                }
                if (anyItemFound) {
                    n += stackBoxSize;
                }
                if (n <= maxWidth) continue;
                maxWidth = n;
            }
            if (x + 15.0f + (float)maxWidth > (float)Minecraft.func_71410_x().func_228018_at_().func_198107_o()) {
                x -= (float)(maxWidth + 24);
            }
            int formatWidth = anyItemFound ? maxWidth - stackBoxSize : maxWidth;
            LinkedList<Tuple> lengthLimitedToolTip = new LinkedList<Tuple>();
            for (Tuple tuple : tooltipData) {
                FontRenderer customFR = ((ItemStack)tuple.func_76341_a()).func_77973_b().getFontRenderer((ItemStack)tuple.func_76341_a());
                if (customFR == null) {
                    customFR = fontRenderer;
                }
                lengthLimitedToolTip.add(new Tuple(tuple.func_76341_a(), (Object)customFR.func_78271_c(((ITextComponent)tuple.func_76340_b()).func_150254_d(), formatWidth)));
            }
            float pX = x + 12.0f;
            float f = y - 12.0f;
            int sumLineHeight = 0;
            if (!lengthLimitedToolTip.isEmpty()) {
                if (lengthLimitedToolTip.size() > 1 && isFirstLineHeadline) {
                    sumLineHeight += 2;
                }
                Iterator iterator = lengthLimitedToolTip.iterator();
                while (iterator.hasNext()) {
                    Tuple toolTip = (Tuple)iterator.next();
                    int segmentHeight = 0;
                    if (!((ItemStack)toolTip.func_76341_a()).func_190926_b()) {
                        segmentHeight += 2;
                        segmentHeight += stackBoxSize;
                        segmentHeight += Math.max(((List)toolTip.func_76340_b()).size() - 1, 0) * 10;
                    } else {
                        segmentHeight += ((List)toolTip.func_76340_b()).size() * 10;
                    }
                    if (!iterator.hasNext()) {
                        segmentHeight -= 2;
                    }
                    sumLineHeight += segmentHeight;
                }
            }
            RenderingDrawUtils.drawGradientRect(zLevel, pX - 3.0f, f - 4.0f, pX + (float)maxWidth + 3.0f, f - 3.0f, color, colorFade);
            RenderingDrawUtils.drawGradientRect(zLevel, pX - 3.0f, f + (float)sumLineHeight + 3.0f, pX + (float)maxWidth + 3.0f, f + (float)sumLineHeight + 4.0f, color, colorFade);
            RenderingDrawUtils.drawGradientRect(zLevel, pX - 3.0f, f - 3.0f, pX + (float)maxWidth + 3.0f, f + (float)sumLineHeight + 3.0f, color, colorFade);
            RenderingDrawUtils.drawGradientRect(zLevel, pX - 4.0f, f - 3.0f, pX - 3.0f, f + (float)sumLineHeight + 3.0f, color, colorFade);
            RenderingDrawUtils.drawGradientRect(zLevel, pX + (float)maxWidth + 3.0f, f - 3.0f, pX + (float)maxWidth + 4.0f, f + (float)sumLineHeight + 3.0f, color, colorFade);
            int col = color & 0xFFFFFF | color & 0xFF000000;
            RenderingDrawUtils.drawGradientRect(zLevel, pX - 3.0f, f - 3.0f + 1.0f, pX - 3.0f + 1.0f, f + (float)sumLineHeight + 3.0f - 1.0f, color, col);
            RenderingDrawUtils.drawGradientRect(zLevel, pX + (float)maxWidth + 2.0f, f - 3.0f + 1.0f, pX + (float)maxWidth + 3.0f, f + (float)sumLineHeight + 3.0f - 1.0f, color, col);
            RenderingDrawUtils.drawGradientRect(zLevel, pX - 3.0f, f - 3.0f, pX + (float)maxWidth + 3.0f, f - 3.0f + 1.0f, col, col);
            RenderingDrawUtils.drawGradientRect(zLevel, pX - 3.0f, f + (float)sumLineHeight + 2.0f, pX + (float)maxWidth + 3.0f, f + (float)sumLineHeight + 3.0f, color, color);
            int offset = anyItemFound ? stackBoxSize : 0;
            boolean first = true;
            for (Tuple toolTip : lengthLimitedToolTip) {
                int minYShift = 10;
                if (!((ItemStack)toolTip.func_76341_a()).func_190926_b()) {
                    RenderingUtils.renderItemStack(Minecraft.func_71410_x().func_175599_af(), (ItemStack)toolTip.func_76341_a(), Math.round(pX), Math.round(f), null);
                    minYShift = stackBoxSize;
                    f += 2.0f;
                }
                for (String str : (List)toolTip.func_76340_b()) {
                    FontRenderer customFR = ((ItemStack)toolTip.func_76341_a()).func_77973_b().getFontRenderer((ItemStack)toolTip.func_76341_a());
                    if (customFR == null) {
                        customFR = fontRenderer;
                    }
                    RenderingDrawUtils.renderStringAtPos(pX + (float)offset, f, zLevel, customFR, str, strColor.getRGB(), false);
                    f += 10.0f;
                    minYShift -= 10;
                }
                if (minYShift > 0) {
                    f += (float)minYShift;
                }
                if (isFirstLineHeadline && first) {
                    f += 2.0f;
                }
                first = false;
            }
        }
    }

    public static void renderBlueTooltipBox(int x, int y, int width, int height) {
        RenderingDrawUtils.renderTooltipBox(x, y, width, height, 39, 68);
    }

    public static void renderTooltipBox(int x, int y, int width, int height, int color, int colorFade) {
        int pX = x + 12;
        int pY = y - 12;
        RenderingDrawUtils.drawGradientRect(0.0f, pX - 3, pY - 4, pX + width + 3, pY - 3, color, colorFade);
        RenderingDrawUtils.drawGradientRect(0.0f, pX - 3, pY + height + 3, pX + width + 3, pY + height + 4, color, colorFade);
        RenderingDrawUtils.drawGradientRect(0.0f, pX - 3, pY - 3, pX + width + 3, pY + height + 3, color, colorFade);
        RenderingDrawUtils.drawGradientRect(0.0f, pX - 4, pY - 3, pX - 3, pY + height + 3, color, colorFade);
        RenderingDrawUtils.drawGradientRect(0.0f, pX + width + 3, pY - 3, pX + width + 4, pY + height + 3, color, colorFade);
        int col = color & 0xFFFFFF | color & 0xFF000000;
        RenderingDrawUtils.drawGradientRect(0.0f, pX - 3, pY - 3 + 1, pX - 3 + 1, pY + height + 3 - 1, color, col);
        RenderingDrawUtils.drawGradientRect(0.0f, pX + width + 2, pY - 3 + 1, pX + width + 3, pY + height + 3 - 1, color, col);
        RenderingDrawUtils.drawGradientRect(0.0f, pX - 3, pY - 3, pX + width + 3, pY - 3 + 1, col, col);
        RenderingDrawUtils.drawGradientRect(0.0f, pX - 3, pY + height + 2, pX + width + 3, pY + height + 3, color, color);
    }

    public static void drawGradientRect(float zLevel, float left, float top, float right, float bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        Blending.DEFAULT.apply();
        RenderSystem.shadeModel((int)7425);
        RenderingUtils.draw(7, DefaultVertexFormats.field_181706_f, buf -> {
            buf.func_225582_a_((double)right, (double)top, (double)zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buf.func_225582_a_((double)left, (double)top, (double)zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buf.func_225582_a_((double)left, (double)bottom, (double)zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            buf.func_225582_a_((double)right, (double)bottom, (double)zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        });
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
    }

    public static void renderLightRayFan(MatrixStack renderStack, IRenderTypeBuffer buffer, Color color, long seed, int minScale, float scale, int count) {
        rand.setSeed(seed);
        float f1 = (float)ClientScheduler.getClientTick() / 400.0f;
        float f2 = 0.0f;
        int alpha = (int)(255.0f * (1.0f - f2));
        IVertexBuilder vb = buffer.getBuffer(RenderTypesAS.EFFECT_LIGHTRAY_FAN);
        renderStack.func_227860_a_();
        for (int i = 0; i < count; ++i) {
            renderStack.func_227860_a_();
            renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rand.nextFloat() * 360.0f));
            renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rand.nextFloat() * 360.0f));
            renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rand.nextFloat() * 360.0f));
            renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rand.nextFloat() * 360.0f));
            renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rand.nextFloat() * 360.0f));
            renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rand.nextFloat() * 360.0f + f1 * 360.0f));
            Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
            float fa = rand.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            vb.func_227888_a_(matr, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
            vb.func_227888_a_(matr, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
            vb.func_227888_a_(matr, -0.7f * (f4 /= 30.0f / (Math.min((float)minScale, 10.0f * scale) / 10.0f)), fa /= 30.0f / (Math.min((float)minScale, 10.0f * scale) / 10.0f), -0.5f * f4).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
            vb.func_227888_a_(matr, 0.7f * f4, fa, -0.5f * f4).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
            vb.func_227888_a_(matr, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
            vb.func_227888_a_(matr, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
            vb.func_227888_a_(matr, 0.7f * f4, fa, -0.5f * f4).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
            vb.func_227888_a_(matr, 0.0f, fa, 1.0f * f4).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
            vb.func_227888_a_(matr, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
            vb.func_227888_a_(matr, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
            vb.func_227888_a_(matr, 0.0f, fa, 1.0f * f4).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
            vb.func_227888_a_(matr, -0.7f * f4, fa, -0.5f * f4).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
            renderStack.func_227865_b_();
        }
        renderStack.func_227865_b_();
        RenderingUtils.refreshDrawing(vb, RenderTypesAS.EFFECT_LIGHTRAY_FAN);
    }

    public static void renderFacingFullQuadVB(IVertexBuilder vb, MatrixStack renderStack, double px, double py, double pz, float scale, float angle, int r, int g, int b, int alpha) {
        RenderingDrawUtils.renderFacingQuadVB(vb, renderStack, px, py, pz, scale, angle, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, alpha);
    }

    public static void renderFacingSpriteVB(IVertexBuilder vb, MatrixStack renderStack, double px, double py, double pz, float scale, float angle, SpriteSheetResource sprite, long spriteTick, int r, int g, int b, int alpha) {
        Tuple<Float, Float> uv = sprite.getUVOffset(spriteTick);
        RenderingDrawUtils.renderFacingQuadVB(vb, renderStack, px, py, pz, scale, angle, ((Float)uv.func_76341_a()).floatValue(), ((Float)uv.func_76340_b()).floatValue(), sprite.getULength(), sprite.getVLength(), r, g, b, alpha);
    }

    public static void renderFacingQuadVB(IVertexBuilder vb, MatrixStack renderStack, double px, double py, double pz, float scale, float angle, float u, float v, float uLength, float vLength, int r, int g, int b, int alpha) {
        Vector3 pos = new Vector3(px, py, pz);
        RenderInfo ri = RenderInfo.getInstance();
        ActiveRenderInfo ari = ri.getARI();
        float arX = ri.getRotationX();
        float arZ = ri.getRotationZ();
        float arYZ = ri.getRotationYZ();
        float arXY = ri.getRotationXY();
        float arXZ = ri.getRotationXZ();
        Vec3d view = ari.func_216785_c();
        Vector3f look = ari.func_227996_l_();
        Vector3 iPos = new Vector3(view);
        Vector3 v1 = new Vector3(-arX * scale - arYZ * scale, -arXZ * scale, -arZ * scale - arXY * scale);
        Vector3 v2 = new Vector3(-arX * scale + arYZ * scale, arXZ * scale, -arZ * scale + arXY * scale);
        Vector3 v3 = new Vector3(arX * scale + arYZ * scale, arXZ * scale, arZ * scale + arXY * scale);
        Vector3 v4 = new Vector3(arX * scale - arYZ * scale, -arXZ * scale, arZ * scale - arXY * scale);
        if (angle != 0.0f) {
            float cAngle = MathHelper.func_76134_b((float)(angle * 0.5f));
            float cAngleSq = cAngle * cAngle;
            Vector3 vAngle = new Vector3(MathHelper.func_76126_a((float)(angle * 0.5f)) * look.func_195899_a(), MathHelper.func_76126_a((float)(angle * 0.5f)) * look.func_195900_b(), MathHelper.func_76126_a((float)(angle * 0.5f)) * look.func_195902_c());
            v1 = vAngle.clone().multiply(2.0 * v1.dot(vAngle)).add(v1.clone().multiply((double)cAngleSq - vAngle.dot(vAngle))).add(vAngle.clone().crossProduct(v1.clone().multiply(2.0f * cAngle)));
            v2 = vAngle.clone().multiply(2.0 * v2.dot(vAngle)).add(v2.clone().multiply((double)cAngleSq - vAngle.dot(vAngle))).add(vAngle.clone().crossProduct(v2.clone().multiply(2.0f * cAngle)));
            v3 = vAngle.clone().multiply(2.0 * v3.dot(vAngle)).add(v3.clone().multiply((double)cAngleSq - vAngle.dot(vAngle))).add(vAngle.clone().crossProduct(v3.clone().multiply(2.0f * cAngle)));
            v4 = vAngle.clone().multiply(2.0 * v4.dot(vAngle)).add(v4.clone().multiply((double)cAngleSq - vAngle.dot(vAngle))).add(vAngle.clone().crossProduct(v4.clone().multiply(2.0f * cAngle)));
        }
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        pos.clone().add(v1).subtract(iPos).drawPos(matr, vb).func_225586_a_(r, g, b, alpha).func_225583_a_(u + uLength, v + vLength).func_181675_d();
        pos.clone().add(v2).subtract(iPos).drawPos(matr, vb).func_225586_a_(r, g, b, alpha).func_225583_a_(u + uLength, v).func_181675_d();
        pos.clone().add(v3).subtract(iPos).drawPos(matr, vb).func_225586_a_(r, g, b, alpha).func_225583_a_(u, v).func_181675_d();
        pos.clone().add(v4).subtract(iPos).drawPos(matr, vb).func_225586_a_(r, g, b, alpha).func_225583_a_(u, v + vLength).func_181675_d();
    }

    public static void renderTexturedCubeCentralColorLighted(IVertexBuilder buf, MatrixStack renderStack, float u, float v, float uLength, float vLength, int r, int g, int b, int a, int combinedLight) {
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        buf.func_227888_a_(matr, -0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227886_a_(combinedLight).func_181675_d();
        buf.func_227888_a_(matr, -0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227886_a_(combinedLight).func_181675_d();
    }

    public static void renderTexturedCubeCentralColorNormal(MatrixStack renderStack, IVertexBuilder vb, float u, float v, float uLength, float vLength, int r, int g, int b, int a, Matrix3f normalMatr) {
        Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
        vb.func_227888_a_(offset, -0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, -0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, 0.5f, -0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, -0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, 0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
        vb.func_227888_a_(offset, -0.5f, 0.5f, 0.5f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_227887_a_(normalMatr, 0.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static void renderAngleRotatedTexturedRectVB(IVertexBuilder vb, MatrixStack renderStack, Vector3 renderOffset, Vector3 axis, float angleRad, float scale, float u, float v, float uLength, float vLength, int r, int g, int b, int a) {
        Vector3 renderStart = axis.clone().perpendicular().rotate(angleRad, axis).normalize();
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Vector3 vec = renderStart.clone().rotate(Math.toRadians(90.0), axis).normalize().multiply(scale).add(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u, v + vLength).func_181675_d();
        vec = renderStart.clone().multiply(-1).normalize().multiply(scale).add(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v + vLength).func_181675_d();
        vec = renderStart.clone().rotate(Math.toRadians(270.0), axis).normalize().multiply(scale).add(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u + uLength, v).func_181675_d();
        vec = renderStart.clone().normalize().multiply(scale).add(renderOffset);
        vec.drawPos(matr, vb).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_181675_d();
    }
}

