/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.camera;

import hellfirepvp.astralsorcery.client.util.camera.ICameraTransformer;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.TickEvent;

public class ClientCameraManager
implements ITickHandler {
    public static final ClientCameraManager INSTANCE = new ClientCameraManager();
    private TreeSet<ICameraTransformer> transformers = new TreeSet<ICameraTransformer>(Comparator.comparingInt(ICameraTransformer::getPriority));
    private ICameraTransformer lastTransformer = null;

    public void tick(TickEvent.Type type, Object ... context) {
        if (type == TickEvent.Type.RENDER) {
            float pTicks = ((Float)context[0]).floatValue();
            if (this.hasActiveTransformer()) {
                ICameraTransformer prio = this.getActiveTransformer();
                if (!prio.equals(this.lastTransformer)) {
                    if (this.lastTransformer != null) {
                        this.lastTransformer.onStopTransforming(pTicks);
                    }
                    prio.onStartTransforming(pTicks);
                    this.lastTransformer = prio;
                }
                prio.transformRenderView(Minecraft.func_71410_x().func_147113_T() ? 0.0f : pTicks);
                if (prio.getPersistencyFunction().isExpired()) {
                    prio.onStopTransforming(pTicks);
                    this.transformers.remove(prio);
                }
            } else if (this.lastTransformer != null) {
                this.lastTransformer.onStopTransforming(pTicks);
                this.lastTransformer = null;
            }
        } else if (!Minecraft.func_71410_x().func_147113_T() && this.hasActiveTransformer()) {
            this.getActiveTransformer().onClientTick();
        }
    }

    public void removeAllAndCleanup() {
        if (this.hasActiveTransformer()) {
            this.transformers.last().onStopTransforming(0.0f);
        }
        this.transformers.clear();
    }

    public void addTransformer(ICameraTransformer transformer) {
        this.transformers.add(transformer);
    }

    public void removeTransformer(ICameraTransformer transformer) {
        this.transformers.remove(transformer);
    }

    @Nullable
    public ICameraTransformer getActiveTransformer() {
        if (this.hasActiveTransformer()) {
            return this.transformers.last();
        }
        return null;
    }

    public boolean hasActiveTransformer() {
        return !this.transformers.isEmpty();
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.RENDER, TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.START;
    }

    public String getName() {
        return "Client Camera Manager";
    }
}

