/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ChaliceHelper {
    @Nonnull
    public static List<BlockPos> findNearbyChalices(World world, BlockPos origin, int distance) {
        distance = MathHelper.func_76125_a((int)distance, (int)0, (int)16);
        Vector3 thisVector = new Vector3((Vec3i)origin).add(0.5, 0.5, 0.5);
        List<BlockPos> foundChalices = BlockDiscoverer.searchForBlocksAround(world, origin, distance, (w, pos, state) -> !w.func_175640_z(pos) && state.func_177230_c().equals(BlocksAS.CHALICE));
        foundChalices.removeIf(pos -> {
            Vector3 chaliceVector = new Vector3((Vec3i)pos).add(0.5, 0.5, 0.5);
            RaytraceAssist assist = new RaytraceAssist(thisVector, chaliceVector);
            return !assist.isClear(world);
        });
        return foundChalices;
    }

    @Nonnull
    public static List<TileChalice> findNearbyChalicesContaining(World world, BlockPos origin, FluidStack expected, int distance) {
        LinkedList<TileChalice> out = new LinkedList<TileChalice>();
        for (BlockPos chalicePos : ChaliceHelper.findNearbyChalices(world, origin, distance)) {
            TileChalice chalice = MiscUtils.getTileAt((IBlockReader)world, chalicePos, TileChalice.class, true);
            if (chalice == null || chalice.getTank().drain(expected, IFluidHandler.FluidAction.SIMULATE).getAmount() < expected.getAmount()) continue;
            out.add(chalice);
        }
        return out;
    }

    @Nonnull
    public static Optional<List<TileChalice>> findNearbyChalicesCombined(World world, BlockPos origin, FluidStack expected, int distance) {
        FluidStack required = expected.copy();
        LinkedList<TileChalice> out = new LinkedList<TileChalice>();
        for (BlockPos chalicePos : ChaliceHelper.findNearbyChalices(world, origin, distance)) {
            FluidStack drained;
            TileChalice chalice = MiscUtils.getTileAt((IBlockReader)world, chalicePos, TileChalice.class, true);
            if (chalice == null || (drained = chalice.getTank().drain(expected, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) continue;
            required.shrink(drained.getAmount());
            out.add(chalice);
        }
        if (required.isEmpty()) {
            return Optional.of(out);
        }
        return Optional.empty();
    }

    public static boolean doChalicesContainCombined(World world, Collection<BlockPos> chalicePositions, FluidStack expected) {
        FluidStack required = expected.copy();
        for (BlockPos pos : chalicePositions) {
            FluidStack drained;
            TileChalice chalice = MiscUtils.getTileAt((IBlockReader)world, pos, TileChalice.class, true);
            if (chalice == null || (drained = chalice.getTank().drain(expected, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) continue;
            required.shrink(drained.getAmount());
        }
        return required.isEmpty();
    }
}

