/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.gateway;

import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayFilter;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.lib.DataAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktUpdateGateways;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class CelestialGatewayHandler {
    public static final CelestialGatewayHandler INSTANCE = new CelestialGatewayHandler();
    private CelestialGatewayFilter filter = null;
    private boolean startUp = false;
    private Map<ResourceLocation, List<GatewayCache.GatewayNode>> serverCache = new HashMap<ResourceLocation, List<GatewayCache.GatewayNode>>();
    private Map<ResourceLocation, List<GatewayCache.GatewayNode>> clientCache = new HashMap<ResourceLocation, List<GatewayCache.GatewayNode>>();

    private CelestialGatewayHandler() {
    }

    private CelestialGatewayFilter getFilter() {
        if (this.filter == null) {
            this.filter = new CelestialGatewayFilter();
        }
        return this.filter;
    }

    public void onServerStart() {
        this.startUp = true;
        CelestialGatewayFilter filter = this.getFilter();
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        DimensionManager.getRegistry().func_201756_e().filter(DimensionManager::keepLoaded).forEach(type -> {
            if (!filter.hasGateways(type.getRegistryName())) {
                return;
            }
            this.loadIntoCache((IWorld)server.func_71218_a(type));
        });
        this.startUp = false;
    }

    public void onWorldInit(WorldEvent.Load event) {
        if (this.startUp) {
            return;
        }
        IWorld world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        this.loadIntoCache(world);
        PktUpdateGateways pkt = new PktUpdateGateways(this.getGatewayCache(LogicalSide.SERVER));
        PacketChannel.CHANNEL.sendToAll(pkt);
    }

    public List<GatewayCache.GatewayNode> getGatewaysForWorld(IWorld world, LogicalSide side) {
        return (side == LogicalSide.SERVER ? this.serverCache : this.clientCache).get(world.func_201675_m().func_186058_p().getRegistryName());
    }

    public Map<ResourceLocation, List<GatewayCache.GatewayNode>> getGatewayCache(LogicalSide side) {
        return Collections.unmodifiableMap(side == LogicalSide.SERVER ? this.serverCache : this.clientCache);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientCache(Map<ResourceLocation, List<GatewayCache.GatewayNode>> positions) {
        this.clientCache = positions;
    }

    private void loadIntoCache(IWorld world) {
        GatewayCache cache = (GatewayCache)DataAS.DOMAIN_AS.getData(world, DataAS.KEY_GATEWAY_CACHE);
        this.serverCache.put(world.func_201675_m().func_186058_p().getRegistryName(), cache.getGatewayPositions());
    }
}

