/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.link;

import hellfirepvp.astralsorcery.common.auxiliary.link.IItemLinkingTool;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkableTileEntity;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class LinkHandler
implements ITickHandler {
    private static final LinkHandler instance = new LinkHandler();
    private static Map<PlayerEntity, LinkSession> players = new HashMap<PlayerEntity, LinkSession>();

    private LinkHandler() {
    }

    public static LinkHandler getInstance() {
        return instance;
    }

    @Nonnull
    public static RightClickResult onRightClick(PlayerEntity clicked, World world, BlockPos pos, boolean sneak) {
        if (!players.containsKey(clicked)) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof LinkableTileEntity)) {
                return new RightClickResult(RightClickResultType.NONE, null);
            }
            LinkableTileEntity tile = (LinkableTileEntity)te;
            players.put(clicked, new LinkSession(tile));
            return new RightClickResult(RightClickResultType.SELECT, tile);
        }
        LinkSession l = players.get(clicked);
        if (sneak) {
            return new RightClickResult(RightClickResultType.TRY_UNLINK, l.selected);
        }
        return new RightClickResult(RightClickResultType.TRY_LINK, l.selected);
    }

    public static void propagateClick(RightClickResult result, PlayerEntity playerIn, World worldIn, BlockPos pos) {
        LinkableTileEntity tile = result.getInteracted();
        Style green = new Style().func_150238_a(TextFormatting.GREEN);
        switch (result.getType()) {
            case SELECT: {
                String name = tile.getUnLocalizedDisplayName();
                if (!tile.onSelect(playerIn) || name == null) break;
                playerIn.func_145747_a(new TranslationTextComponent("astralsorcery.misc.link.start", new Object[]{new TranslationTextComponent(name, new Object[0])}).func_150255_a(green));
                break;
            }
            case TRY_LINK: {
                String linkedFrom;
                String unloc;
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof LinkableTileEntity && !((LinkableTileEntity)te).doesAcceptLinks()) {
                    return;
                }
                if (!tile.tryLink(playerIn, pos)) break;
                tile.onLinkCreate(playerIn, pos);
                String linkedTo = "astralsorcery.misc.link.link.block";
                if (te instanceof LinkableTileEntity && (unloc = ((LinkableTileEntity)te).getUnLocalizedDisplayName()) != null) {
                    linkedTo = unloc;
                }
                if ((linkedFrom = tile.getUnLocalizedDisplayName()) == null) break;
                playerIn.func_145747_a(new TranslationTextComponent("astralsorcery.misc.link.link", new Object[]{new TranslationTextComponent(linkedFrom, new Object[0]), new TranslationTextComponent(linkedTo, new Object[0])}).func_150255_a(green));
                break;
            }
            case TRY_UNLINK: {
                String linkedFrom;
                String unloc;
                if (!tile.tryUnlink(playerIn, pos)) break;
                String linkedTo = "astralsorcery.misc.link.link.block";
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof LinkableTileEntity && (unloc = ((LinkableTileEntity)te).getUnLocalizedDisplayName()) != null) {
                    linkedTo = unloc;
                }
                if ((linkedFrom = tile.getUnLocalizedDisplayName()) == null) break;
                playerIn.func_145747_a(new TranslationTextComponent("astralsorcery.misc.link.unlink", new Object[]{new TranslationTextComponent(linkedFrom, new Object[0]), new TranslationTextComponent(linkedTo, new Object[0])}).func_150255_a(green));
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    public void tick(TickEvent.Type type, Object ... context) {
        Iterator<PlayerEntity> iterator = players.keySet().iterator();
        while (iterator.hasNext()) {
            int dimId;
            PlayerEntity pl = iterator.next();
            LinkSession session = players.get(pl);
            boolean needsRemoval = true;
            ItemStack inhand = pl.func_184614_ca();
            if (!inhand.func_190926_b() && inhand.func_77973_b() instanceof IItemLinkingTool) {
                needsRemoval = false;
            }
            if (!(inhand = pl.func_184592_cb()).func_190926_b() && inhand.func_77973_b() instanceof IItemLinkingTool) {
                needsRemoval = false;
            }
            if ((dimId = session.selected.getLinkWorld().func_201675_m().func_186058_p().func_186068_a()) != pl.field_71093_bK.func_186068_a()) {
                needsRemoval = true;
            }
            if (!needsRemoval) continue;
            iterator.remove();
            pl.func_145747_a(new TranslationTextComponent("astralsorcery.misc.link.stop", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "LinkHandler";
    }

    public static enum RightClickResultType {
        SELECT,
        TRY_LINK,
        TRY_UNLINK,
        NONE;

    }

    public static class RightClickResult {
        private final RightClickResultType type;
        private final LinkableTileEntity interacted;

        RightClickResult(RightClickResultType type, LinkableTileEntity interacted) {
            this.type = type;
            this.interacted = interacted;
        }

        public RightClickResultType getType() {
            return this.type;
        }

        LinkableTileEntity getInteracted() {
            return this.interacted;
        }
    }

    public static class LinkSession {
        private final LinkableTileEntity selected;

        public LinkSession(LinkableTileEntity selected) {
            this.selected = selected;
        }
    }
}

