/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.types;

import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.RenderTypesAS;
import hellfirepvp.astralsorcery.client.render.ObjModelRender;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.base.patreon.FlareColor;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.awt.Color;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class TypeCelestialWings
extends PatreonEffect
implements ITickHandler {
    private final UUID playerUUID;

    public TypeCelestialWings(UUID effectUUID, @Nullable FlareColor flareColor, UUID playerUUID) {
        super(effectUUID, flareColor);
        this.playerUUID = playerUUID;
    }

    @Override
    public void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.register((Object)this);
    }

    @Override
    public void attachTickListeners(Consumer<ITickHandler> registrar) {
        super.attachTickListeners(registrar);
        registrar.accept(this);
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity player = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        if (side.isClient() && this.shouldDoEffect(player) && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.playerUUID) && Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            this.playEffects(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects(PlayerEntity player) {
        float rot = RenderingVectorUtils.interpolateRotation(player.field_70760_ar, player.field_70761_aq, 0.0f);
        float yOffset = 1.3f;
        if (player.func_225608_bj_()) {
            yOffset = 1.0f;
        }
        float f = Math.abs((float)(ClientScheduler.getSystemClientTick() % 240L) - 120.0f) / 120.0f;
        double offset = Math.cos((double)(f * 2.0f) * Math.PI) * 0.03;
        Vector3 look = new Vector3(1, 0, 0).rotate(Math.toRadians(360.0f - rot), Vector3.RotAxis.Y_AXIS).normalize();
        Vector3 pos = Vector3.atEntityCorner((Entity)player);
        pos.setY(player.func_226278_cu_() + (double)yOffset + offset);
        for (int i = 0; i < 4; ++i) {
            double height = -0.1 + Math.min((double)rand.nextFloat() * 1.3, (double)rand.nextFloat() * 1.3);
            double distance = (double)1.2f - (double)rand.nextFloat() * 0.6 * (1.0 - Math.max(0.0, height));
            Vector3 dir = look.clone().rotate(Math.toRadians(180 * (rand.nextBoolean() ? 1 : 0)), Vector3.RotAxis.Y_AXIS).normalize().multiply(distance);
            Vector3 at = pos.clone().addY(height).add(dir);
            Color col = Color.getHSBColor(0.68f, 1.0f, 0.6f - rand.nextFloat() * 0.5f);
            FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).color(VFXColorFunction.constant(col))).setScaleMultiplier(0.27f + rand.nextFloat() * 0.1f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(25 + rand.nextInt(20));
            if (rand.nextInt(4) == 0) {
                ((EntityComplexFX)((EntityVisualFX)p.setScaleMultiplier(0.09f + rand.nextFloat() * 0.02f)).color(VFXColorFunction.WHITE)).setMaxAge(10 + rand.nextInt(8));
                continue;
            }
            p.setGravityStrength(3.0E-4f);
        }
    }

    private boolean shouldDoEffect(PlayerEntity player) {
        return player.func_110124_au().equals(this.playerUUID) && !player.func_184218_aH() && !player.func_184613_cA() && !player.func_70644_a(Effects.field_76441_p);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    void onRender(RenderPlayerEvent.Post event) {
        PlayerEntity player = event.getPlayer();
        if (!this.shouldDoEffect(player)) {
            return;
        }
        this.renderWings(player, event.getMatrixStack(), event.getPartialRenderTick());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderWings(PlayerEntity player, MatrixStack renderStack, float pTicks) {
        float rot = RenderingVectorUtils.interpolateRotation(player.field_70760_ar, player.field_70761_aq, pTicks);
        float yOffset = 1.3f;
        if (player.func_225608_bj_() && !player.field_71075_bZ.field_75100_b) {
            yOffset = 1.0f;
        }
        float f = Math.abs((float)(ClientScheduler.getSystemClientTick() % 240L) - 120.0f) / 120.0f;
        double offset = Math.cos((double)(f * 2.0f) * Math.PI) * 0.03;
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(0.0, (double)yOffset + offset, 0.0);
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rot));
        renderStack.func_227862_a_(0.02f, 0.02f, 0.02f);
        RenderTypesAS.MODEL_CELESTIAL_WINGS.func_228547_a_();
        renderStack.func_227861_a_(-25.0, 0.0, 0.0);
        ObjModelRender.renderCelestialWings(renderStack);
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        renderStack.func_227861_a_(-50.0, 0.0, 0.0);
        ObjModelRender.renderCelestialWings(renderStack);
        renderStack.func_227865_b_();
        RenderTypesAS.MODEL_CELESTIAL_WINGS.func_228549_b_();
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "PatreonEffect - Celestial Wings " + this.playerUUID.toString();
    }
}

