/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.common.block.base.BlockCrystalContainer;
import hellfirepvp.astralsorcery.common.block.base.BlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.tile.crystal.CollectorCrystalType;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockCelestialCrystalCluster;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.TileCelestialCrystals;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockCelestialCrystalCluster
extends BlockCrystalContainer
implements BlockStarlightRecipient,
CustomItemBlock {
    private static final VoxelShape GROWTH_STAGE_0 = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)8.0, (double)11.0);
    private static final VoxelShape GROWTH_STAGE_1 = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0);
    private static final VoxelShape GROWTH_STAGE_2 = Block.func_208617_a((double)2.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape GROWTH_STAGE_3 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape GROWTH_STAGE_4 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)4);

    public BlockCelestialCrystalCluster() {
        super(Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)CollectorCrystalType.CELESTIAL_CRYSTAL.getMaterialColor()).func_200948_a(3.0f, 3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200947_a(SoundType.field_185853_f).func_200951_a(8));
    }

    @Override
    public Class<? extends BlockItem> getItemBlockClass() {
        return ItemBlockCelestialCrystalCluster.class;
    }

    @Override
    public void receiveStarlight(World world, Random rand, BlockPos pos, IWeakConstellation starlightType, double amount) {
        TileCelestialCrystals crystals = MiscUtils.getTileAt((IBlockReader)world, pos, TileCelestialCrystals.class, false);
        if (crystals != null) {
            crystals.grow((int)(24000.0 / amount));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape shape;
        Vec3d offset = state.func_191059_e(world, pos);
        switch ((Integer)state.func_177229_b((IProperty)STAGE)) {
            case 4: {
                shape = GROWTH_STAGE_4;
                break;
            }
            case 3: {
                shape = GROWTH_STAGE_3;
                break;
            }
            case 2: {
                shape = GROWTH_STAGE_2;
                break;
            }
            case 1: {
                shape = GROWTH_STAGE_1;
                break;
            }
            default: {
                shape = GROWTH_STAGE_0;
            }
        }
        return shape.func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public Vec3d func_190949_e(BlockState state, IBlockReader world, BlockPos pos) {
        return super.func_190949_e(state, world, pos).func_216372_d(0.7, 0.7, 0.7);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return BlockCelestialCrystalCluster.func_220064_c((IBlockReader)worldIn, (BlockPos)blockpos) || BlockCelestialCrystalCluster.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, world, pos, newState, isMoving);
            PktPlayEffect effect = new PktPlayEffect(PktPlayEffect.Type.SMALL_CRYSTAL_BREAK).addData(buf -> ByteBufUtils.writeVector(buf, new Vector3((Vec3i)pos).add(state.func_191059_e((IBlockReader)world, pos)).add(0.5, 0.4, 0.5)));
            PacketChannel.CHANNEL.sendToAllAround(effect, PacketChannel.pointFromPos((IWorld)world, (Vec3i)pos, 32.0));
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileCelestialCrystals();
    }
}

