/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.tile.crystal.CollectorCrystalType;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockGemCrystalCluster;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.TileGemCrystals;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockGemCrystalCluster
extends ContainerBlock
implements CustomItemBlock {
    private static final VoxelShape STAGE_0 = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape STAGE_1 = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape STAGE_2_SKY = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape STAGE_2_DAY = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape STAGE_2_NIGHT = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    public static final EnumProperty<GrowthStageType> STAGE = EnumProperty.func_177709_a((String)"stage", GrowthStageType.class);

    public BlockGemCrystalCluster() {
        super(Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)CollectorCrystalType.ROCK_CRYSTAL.getMaterialColor()).func_200948_a(3.0f, 3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200947_a(SoundType.field_185853_f).func_200951_a(6));
    }

    @Override
    public Class<? extends BlockItem> getItemBlockClass() {
        return ItemBlockGemCrystalCluster.class;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Vec3d offset = state.func_191059_e(world, pos);
        VoxelShape shape = VoxelShapes.func_197868_b();
        switch ((GrowthStageType)((Object)state.func_177229_b(STAGE))) {
            case STAGE_0: {
                shape = STAGE_0;
                break;
            }
            case STAGE_1: {
                shape = STAGE_1;
                break;
            }
            case STAGE_2_SKY: {
                shape = STAGE_2_SKY;
                break;
            }
            case STAGE_2_DAY: {
                shape = STAGE_2_DAY;
                break;
            }
            case STAGE_2_NIGHT: {
                shape = STAGE_2_NIGHT;
            }
        }
        return shape.func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public Vec3d func_190949_e(BlockState state, IBlockReader world, BlockPos pos) {
        return super.func_190949_e(state, world, pos).func_216372_d(0.7, 0.7, 0.7);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return BlockGemCrystalCluster.func_220064_c((IBlockReader)worldIn, (BlockPos)blockpos) || BlockGemCrystalCluster.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, world, pos, newState, isMoving);
            PktPlayEffect effect = new PktPlayEffect(PktPlayEffect.Type.GEM_CRYSTAL_BREAK).addData(buf -> {
                ByteBufUtils.writeVector(buf, new Vector3((Vec3i)pos).add(state.func_191059_e((IBlockReader)world, pos)));
                buf.writeInt(((GrowthStageType)((Object)((Object)state.func_177229_b(STAGE)))).ordinal());
            });
            PacketChannel.CHANNEL.sendToAllAround(effect, PacketChannel.pointFromPos((IWorld)world, (Vec3i)pos, 32.0));
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileGemCrystals();
    }

    public static enum GrowthStageType implements IStringSerializable
    {
        STAGE_0(0, Color.WHITE),
        STAGE_1(1, Color.WHITE),
        STAGE_2_SKY(2, ColorsAS.GEM_SKY),
        STAGE_2_DAY(2, ColorsAS.GEM_DAY),
        STAGE_2_NIGHT(2, ColorsAS.GEM_NIGHT);

        private final int growthStage;
        private final Color displayColor;

        private GrowthStageType(int growthStage, Color displayColor) {
            this.growthStage = growthStage;
            this.displayColor = displayColor;
        }

        public Color getDisplayColor() {
            return this.displayColor;
        }

        public int getGrowthStage() {
            return this.growthStage;
        }

        public GrowthStageType grow(World world) {
            if (this == STAGE_0) {
                return STAGE_1;
            }
            if (this == STAGE_1) {
                if (DayTimeHelper.isDay(world)) {
                    return STAGE_2_DAY;
                }
                if (DayTimeHelper.isNight(world)) {
                    return STAGE_2_NIGHT;
                }
                return STAGE_2_SKY;
            }
            return this;
        }

        public GrowthStageType shrink() {
            int stage = this.getGrowthStage();
            if (stage == 2) {
                return STAGE_1;
            }
            return STAGE_0;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

