/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.GuiType;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.base.LargeBlock;
import hellfirepvp.astralsorcery.common.block.properties.PropertiesWood;
import hellfirepvp.astralsorcery.common.item.ItemParchment;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.tile.TileRefractionTable;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockRefractionTable
extends ContainerBlock
implements CustomItemBlock,
LargeBlock {
    private static final VoxelShape REFRACTION_TABLE = Block.func_208617_a((double)-6.0, (double)0.0, (double)-4.0, (double)22.0, (double)24.0, (double)20.0);
    private static final AxisAlignedBB PLACEMENT_BOX = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 1.0, 1.0);

    public BlockRefractionTable() {
        super(PropertiesWood.defaultInfusedWood().func_226896_b_());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return REFRACTION_TABLE;
    }

    @Override
    public AxisAlignedBB getBlockSpace() {
        return PLACEMENT_BOX;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.canPlaceAt(context) ? this.func_176223_P() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < rand.nextInt(3); ++i) {
            Vector3 offset = new Vector3(-0.3125, 1.505, -0.1875);
            int random = rand.nextInt(ColorsAS.REFRACTION_TABLE_COLORS.length);
            if (random >= ColorsAS.REFRACTION_TABLE_COLORS.length / 2) {
                offset.addX(1.5);
            }
            offset.addZ((double)(random % (ColorsAS.REFRACTION_TABLE_COLORS.length / 2)) * 0.25);
            offset.add((double)rand.nextFloat() * 0.1, 0.0, (double)rand.nextFloat() * 0.1).add((Vec3i)pos);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.constant(ColorsAS.REFRACTION_TABLE_COLORS[random]))).setMaxAge(35 + rand.nextInt(30));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileRefractionTable tft;
        ItemStack held = player.func_184586_b(hand);
        if (!world.func_201670_d() && (tft = MiscUtils.getTileAt((IBlockReader)world, pos, TileRefractionTable.class, true)) != null) {
            if (player.func_225608_bj_()) {
                if (!tft.getInputStack().func_190926_b()) {
                    ItemStack remaining = ItemUtils.dropItemToPlayer(player, tft.setInputStack(ItemStack.field_190927_a));
                    if (!remaining.func_190926_b()) {
                        ItemUtils.dropItemNaturally(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), remaining);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (!tft.getGlassStack().func_190926_b()) {
                    ItemStack remaining = ItemUtils.dropItemToPlayer(player, tft.setGlassStack(ItemStack.field_190927_a));
                    if (!remaining.func_190926_b()) {
                        ItemUtils.dropItemNaturally(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), remaining);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else if (!held.func_190926_b()) {
                if (held.func_77973_b() instanceof ItemParchment && tft.getParchmentCount() < 64) {
                    int leftover = tft.addParchment(held.func_190916_E());
                    if (leftover < tft.getParchmentCount() && !player.func_184812_l_()) {
                        held.func_190920_e(leftover);
                        if (held.func_190926_b()) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        } else {
                            player.func_184611_a(hand, held);
                        }
                    }
                } else {
                    if (TileRefractionTable.isValidGlassStack(held) && tft.getGlassStack().func_190926_b()) {
                        ItemStack previous = tft.setGlassStack(ItemUtils.copyStackWithSize(held, 1));
                        if (!previous.func_190926_b()) {
                            ItemUtils.dropItemNaturally(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.8, (double)pos.func_177952_p() + 0.5, previous);
                        }
                        if (!player.func_184812_l_()) {
                            held.func_190918_g(1);
                            if (held.func_190926_b()) {
                                player.func_184611_a(hand, ItemStack.field_190927_a);
                            } else {
                                player.func_184611_a(hand, held);
                            }
                        }
                        return ActionResultType.PASS;
                    }
                    if (tft.getInputStack().func_190926_b()) {
                        ItemStack previous = tft.setInputStack(ItemUtils.copyStackWithSize(held, 1));
                        if (!previous.func_190926_b()) {
                            ItemUtils.dropItemNaturally(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.8, (double)pos.func_177952_p() + 0.5, previous);
                        }
                        if (!player.func_184812_l_()) {
                            held.func_190918_g(1);
                            if (held.func_190926_b()) {
                                player.func_184611_a(hand, ItemStack.field_190927_a);
                            } else {
                                player.func_184611_a(hand, held);
                            }
                        }
                    } else {
                        AstralSorcery.getProxy().openGui(player, GuiType.REFRACTION_TABLE, pos);
                    }
                }
            } else {
                AstralSorcery.getProxy().openGui(player, GuiType.REFRACTION_TABLE, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileRefractionTable te = MiscUtils.getTileAt((IBlockReader)world, pos, TileRefractionTable.class, true);
        if (te != null && !world.field_72995_K) {
            te.dropContents();
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileRefractionTable();
    }
}

