/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.common.block.base.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.properties.PropertiesMarble;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefaction;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefactionContext;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.VoxelUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.astralsorcery.common.util.tile.TileInventoryFiltered;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlockWell
extends BlockStarlightNetwork
implements CustomItemBlock {
    private final VoxelShape shape = this.createShape();

    public BlockWell() {
        super(PropertiesMarble.defaultMarble().harvestLevel(1).harvestTool(ToolType.PICKAXE));
    }

    protected VoxelShape createShape() {
        VoxelShape footing = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape floor = Block.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
        VoxelShape basinFloor = Block.func_208617_a((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
        VoxelShape w1 = Block.func_208617_a((double)1.0, (double)5.0, (double)1.0, (double)2.0, (double)16.0, (double)14.0);
        VoxelShape w2 = Block.func_208617_a((double)2.0, (double)5.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0);
        VoxelShape w3 = Block.func_208617_a((double)14.0, (double)5.0, (double)2.0, (double)15.0, (double)16.0, (double)15.0);
        VoxelShape w4 = Block.func_208617_a((double)1.0, (double)5.0, (double)14.0, (double)14.0, (double)16.0, (double)15.0);
        return VoxelUtils.combineAll(IBooleanFunction.field_223244_o_, footing, floor, basinFloor, w1, w2, w3, w4);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.shape;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem;
        if (!world.func_201670_d() && !(heldItem = player.func_184586_b(hand)).func_190926_b()) {
            TileWell tw = MiscUtils.getTileAt((IBlockReader)world, pos, TileWell.class, false);
            if (tw == null) {
                return ActionResultType.PASS;
            }
            WellLiquefaction entry = RecipeTypesAS.TYPE_WELL.findRecipe(new WellLiquefactionContext(heldItem));
            if (entry != null) {
                TileInventoryFiltered handle = tw.getInventory();
                if (!handle.getStackInSlot(0).func_190926_b()) {
                    return ActionResultType.PASS;
                }
                if (!world.func_175623_d(pos.func_177984_a())) {
                    return ActionResultType.PASS;
                }
                handle.setStackInSlot(0, ItemUtils.copyStackWithSize(heldItem, 1));
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                if (heldItem.func_190916_E() <= 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
            tw.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                FluidActionResult far = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)handler, (IItemHandler)new InvWrapper((IInventory)player.field_71071_by), (int)1000, (PlayerEntity)player, (boolean)true);
                if (far.isSuccess()) {
                    player.func_184611_a(hand, far.getResult());
                    SoundHelper.playSoundAround(SoundEvents.field_187630_M, world, (Vec3i)pos, 1.0f, 1.0f);
                    tw.markForUpdate();
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemStack stack;
        TileWell tw = MiscUtils.getTileAt((IBlockReader)worldIn, pos, TileWell.class, true);
        if (tw != null && !worldIn.field_72995_K && !(stack = tw.getInventory().getStackInSlot(0)).func_190926_b()) {
            tw.breakCatalyst();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileWell tw = MiscUtils.getTileAt((IBlockReader)world, pos, TileWell.class, false);
        if (tw != null) {
            int fluidPart = MathHelper.func_76123_f((float)(tw.getTank().getPercentageFilled() * 8.0f));
            return tw.getCatalyst().func_190926_b() ? fluidPart : fluidPart + 7;
        }
        return 0;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileWell();
    }
}

