/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.cmd.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ArgumentTypeConstellation
implements ArgumentType<IConstellation> {
    public static final SimpleCommandExceptionType CONSTELLATION_NOT_FOUND = new SimpleCommandExceptionType((Message)new TranslationTextComponent("astralsorcery.command.argument.constellation.notfound", new Object[0]));
    private final Predicate<IConstellation> filter;

    private ArgumentTypeConstellation(Predicate<IConstellation> filter) {
        this.filter = filter;
    }

    public IConstellation parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation name = ResourceLocation.func_195826_a((StringReader)reader);
        for (IConstellation cst : ConstellationRegistry.getAllConstellations()) {
            if (!this.filter.test(cst) || !cst.getRegistryName().equals((Object)name)) continue;
            return cst;
        }
        throw CONSTELLATION_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a((Iterable)ConstellationRegistry.getAllConstellations().stream().filter(this.filter).map(IForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }

    public static ArgumentTypeConstellation weak() {
        return new ArgumentTypeConstellation(c -> c instanceof IWeakConstellation);
    }

    public static ArgumentTypeConstellation major() {
        return new ArgumentTypeConstellation(c -> c instanceof IMajorConstellation);
    }

    public static ArgumentTypeConstellation minor() {
        return new ArgumentTypeConstellation(c -> c instanceof IMinorConstellation);
    }

    public static ArgumentTypeConstellation any() {
        return new ArgumentTypeConstellation(c -> true);
    }
}

