/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ConstellationBase
extends ForgeRegistryEntry<IConstellation>
implements IConstellation {
    private static int counter = 0;
    private List<StarLocation> starLocations = new ArrayList<StarLocation>();
    private List<StarConnection> connections = new ArrayList<StarConnection>();
    private List<Ingredient> signatureItems = new LinkedList<Ingredient>();
    private final String name;
    private final String simpleName;
    private final Color color;
    private final int id = counter++;

    public ConstellationBase(String name) {
        this(name, ColorsAS.CONSTELLATION_TYPE_MAJOR);
    }

    public ConstellationBase(String name, Color color) {
        this.simpleName = name;
        ModContainer mod = MiscUtils.getCurrentlyActiveMod();
        if (mod != null) {
            this.setRegistryName(new ResourceLocation(mod.getModId(), name));
            this.name = mod.getModId() + ".constellation." + name;
        } else {
            this.setRegistryName(AstralSorcery.key(name));
            this.name = "unknown.constellation." + name;
        }
        this.color = color;
    }

    @Override
    public StarLocation addStar(int x, int y) {
        StarLocation star = new StarLocation(x %= 30, y %= 30);
        if (!this.starLocations.contains(star)) {
            this.starLocations.add(star);
            return star;
        }
        return null;
    }

    @Override
    public StarConnection addConnection(StarLocation star1, StarLocation star2) {
        if (star1.equals(star2)) {
            return null;
        }
        StarConnection sc = new StarConnection(star1, star2);
        if (!this.connections.contains(sc)) {
            this.connections.add(sc);
            return sc;
        }
        return null;
    }

    @Override
    public ConstellationBase addSignatureItem(Ingredient handle) {
        this.signatureItems.add(handle);
        return this;
    }

    @Override
    public List<Ingredient> getConstellationSignatureItems() {
        return Collections.unmodifiableList(this.signatureItems);
    }

    @Override
    public boolean canDiscover(PlayerEntity player, PlayerProgress progress) {
        return true;
    }

    @Override
    public int getSortingId() {
        return this.id;
    }

    @Override
    public Color getConstellationColor() {
        return this.color;
    }

    @Override
    public List<StarLocation> getStars() {
        return Collections.unmodifiableList(this.starLocations);
    }

    @Override
    public List<StarConnection> getStarConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    @Override
    public String getTranslationKey() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    public String toString() {
        return "Constellation={name:" + this.name + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstellationBase that = (ConstellationBase)o;
        return Objects.equals(this.getRegistryName(), that.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    @Override
    public int compareTo(IConstellation o) {
        return Integer.compare(this.getSortingId(), o.getSortingId());
    }

    public static class Minor
    extends ConstellationBase
    implements IMinorConstellation {
        private final List<MoonPhase> phases;

        public Minor(String name, MoonPhase ... applicablePhases) {
            super(name);
            this.phases = new ArrayList<MoonPhase>(applicablePhases.length);
            for (MoonPhase ph : applicablePhases) {
                if (ph == null) {
                    throw new IllegalArgumentException("null MoonPhase passed to Minor constellation registration for " + name);
                }
                this.phases.add(ph);
            }
        }

        public Minor(String name, Color color, MoonPhase ... applicablePhases) {
            super(name, color);
            this.phases = new ArrayList<MoonPhase>(applicablePhases.length);
            for (MoonPhase ph : applicablePhases) {
                if (ph == null) {
                    throw new IllegalArgumentException("null MoonPhase passed to Minor constellation registration for " + name);
                }
                this.phases.add(ph);
            }
        }

        @Override
        public List<MoonPhase> getShowupMoonPhases(long rSeed) {
            ArrayList<MoonPhase> shifted = new ArrayList<MoonPhase>(this.phases.size());
            for (MoonPhase mp : this.phases) {
                int index;
                for (index = mp.ordinal() + ((int)(rSeed % (long)MoonPhase.values().length) + MoonPhase.values().length); index >= MoonPhase.values().length; index -= MoonPhase.values().length) {
                }
                index = MathHelper.func_76125_a((int)index, (int)0, (int)(MoonPhase.values().length - 1));
                MoonPhase offset = MoonPhase.values()[index];
                if (shifted.contains((Object)offset)) continue;
                shifted.add(offset);
            }
            return shifted;
        }

        @Override
        public boolean canDiscover(PlayerEntity player, PlayerProgress progress) {
            return super.canDiscover(player, progress) && progress.wasOnceAttuned() && progress.getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT);
        }
    }

    public static abstract class WeakSpecial
    extends Weak
    implements IConstellationSpecialShowup {
        public WeakSpecial(String name) {
            super(name);
        }

        public WeakSpecial(String name, Color color) {
            super(name, color);
        }
    }

    public static class Weak
    extends ConstellationBase
    implements IWeakConstellation {
        public Weak(String name) {
            super(name);
        }

        public Weak(String name, Color color) {
            super(name, color);
        }

        @Override
        public boolean canDiscover(PlayerEntity player, PlayerProgress progress) {
            return super.canDiscover(player, progress) && progress.getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT) && progress.wasOnceAttuned();
        }
    }

    public static class Major
    extends Weak
    implements IMajorConstellation {
        public Major(String name) {
            super(name);
        }

        public Major(String name, Color color) {
            super(name, color);
        }

        @Override
        public boolean canDiscover(PlayerEntity player, PlayerProgress progress) {
            return true;
        }
    }
}

