/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class ConstellationRegistry {
    private static SortedSet<IMajorConstellation> majorConstellations = new TreeSet<IMajorConstellation>();
    private static SortedSet<IWeakConstellation> weakConstellations = new TreeSet<IWeakConstellation>();
    private static SortedSet<IMinorConstellation> minorConstellations = new TreeSet<IMinorConstellation>();
    private static SortedSet<IConstellationSpecialShowup> specialShowupConstellations = new TreeSet<IConstellationSpecialShowup>();

    public static <T extends IConstellation> void addConstellation(T constellation) {
        if (constellation instanceof IWeakConstellation) {
            if (constellation instanceof IMajorConstellation) {
                majorConstellations.add((IMajorConstellation)constellation);
            }
            weakConstellations.add((IWeakConstellation)constellation);
        } else if (constellation instanceof IMinorConstellation) {
            minorConstellations.add((IMinorConstellation)constellation);
        } else {
            AstralSorcery.log.warn("Tried to register constellation that's neither minor nor major or weak: " + constellation.toString());
            AstralSorcery.log.warn("Skipping specific constellation registration...");
            throw new IllegalArgumentException("Tried to register non-minor, non-weak and non-major constellation.");
        }
        if (constellation instanceof IConstellationSpecialShowup) {
            specialShowupConstellations.add((IConstellationSpecialShowup)constellation);
        }
    }

    @Nullable
    public static IConstellation getConstellation(ResourceLocation name) {
        return (IConstellation)RegistriesAS.REGISTRY_CONSTELLATIONS.getValue(name);
    }

    public static Collection<IConstellationSpecialShowup> getSpecialShowupConstellations() {
        return Collections.unmodifiableCollection(specialShowupConstellations);
    }

    public static Collection<IWeakConstellation> getWeakConstellations() {
        return Collections.unmodifiableCollection(weakConstellations);
    }

    public static Collection<IMajorConstellation> getMajorConstellations() {
        return Collections.unmodifiableCollection(majorConstellations);
    }

    public static Collection<IMinorConstellation> getMinorConstellations() {
        return Collections.unmodifiableCollection(minorConstellations);
    }

    public static Collection<IConstellation> getAllConstellations() {
        ArrayList<IConstellation> all = new ArrayList<IConstellation>(RegistriesAS.REGISTRY_CONSTELLATIONS.getValues());
        Collections.sort(all);
        return all;
    }
}

