/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.world.WorldSeedCache;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class SkyHandler
implements ITickHandler {
    private static final SkyHandler instance = new SkyHandler();
    private Map<Integer, WorldContext> worldHandlersServer = Maps.newHashMap();
    private Map<Integer, WorldContext> worldHandlersClient = Maps.newHashMap();
    private Map<Integer, Boolean> skyRevertMap = Maps.newHashMap();

    private SkyHandler() {
    }

    public static SkyHandler getInstance() {
        return instance;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        if (type == TickEvent.Type.WORLD) {
            World w = (World)context[0];
            if (!w.field_72995_K) {
                int dimId = w.func_201675_m().func_186058_p().func_186068_a();
                this.skyRevertMap.put(dimId, false);
                WorldContext ctx = this.worldHandlersServer.get(dimId);
                if (ctx == null) {
                    ctx = this.createContext(MiscUtils.getRandomWorldSeed((IWorld)w));
                    this.worldHandlersServer.put(dimId, ctx);
                }
                ctx.tick(w);
            }
        } else {
            this.handleClientTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClientTick() {
        ClientWorld w = Minecraft.func_71410_x().field_71441_e;
        if (w != null) {
            int dimId = w.func_201675_m().func_186058_p().func_186068_a();
            WorldContext ctx = this.worldHandlersClient.get(dimId);
            if (ctx == null) {
                Optional<Long> seedOpt = WorldSeedCache.getSeedIfPresent((World)w);
                if (!seedOpt.isPresent()) {
                    return;
                }
                ctx = this.createContext(seedOpt.get());
                this.worldHandlersClient.put(dimId, ctx);
            }
            ctx.tick((World)w);
        }
    }

    private WorldContext createContext(long seed) {
        return new WorldContext(seed);
    }

    @Nullable
    public static WorldContext getContext(World world) {
        return SkyHandler.getContext(world, world.func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER);
    }

    @Nullable
    public static WorldContext getContext(World world, LogicalSide dist) {
        if (world == null) {
            return null;
        }
        int dimId = world.func_201675_m().func_186058_p().func_186068_a();
        if (dist.isClient()) {
            return SkyHandler.getInstance().worldHandlersClient.getOrDefault(dimId, null);
        }
        return SkyHandler.getInstance().worldHandlersServer.getOrDefault(dimId, null);
    }

    public void revertWorldTimeTick(World world) {
        int dimId = world.func_201675_m().func_186058_p().func_186068_a();
        Boolean state = this.skyRevertMap.get(dimId);
        if (!world.field_72995_K && state != null && !state.booleanValue()) {
            this.skyRevertMap.put(dimId, true);
            world.func_72877_b(world.func_72820_D() - 1L);
        }
    }

    public void clientClearCache() {
        this.worldHandlersClient.clear();
    }

    public void informWorldUnload(IWorld world) {
        this.worldHandlersServer.remove(world.func_201675_m().func_186058_p().func_186068_a());
        this.worldHandlersClient.remove(world.func_201675_m().func_186058_p().func_186068_a());
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD, TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "ConstellationSkyhandler";
    }
}

