/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ConstellationEffect {
    protected static final Random rand = new Random();
    protected static final AxisAlignedBB BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final IWeakConstellation cst;
    private final ILocatable pos;
    private boolean needsChunkToBeLoaded = false;

    protected ConstellationEffect(@Nonnull ILocatable origin, @Nonnull IWeakConstellation cst) {
        this.cst = cst;
        this.pos = origin;
    }

    protected void setChunkNeedsToBeLoaded() {
        this.needsChunkToBeLoaded = true;
    }

    public boolean needsChunkToBeLoaded() {
        return this.needsChunkToBeLoaded;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void playClientEffect(World var1, BlockPos var2, TileRitualPedestal var3, float var4, boolean var5);

    public abstract boolean playEffect(World var1, BlockPos var2, ConstellationEffectProperties var3, @Nullable IMinorConstellation var4);

    @Nullable
    public TileRitualPedestal getPedestal(World world, BlockPos pos) {
        TileEntity te = MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, false);
        if (te instanceof TileRitualLink) {
            TileRitualLink link = (TileRitualLink)te;
            pos = link.getLinkedTo();
            return MiscUtils.getTileAt((IBlockReader)world, pos, TileRitualPedestal.class, false);
        }
        return te instanceof TileRitualPedestal ? (TileRitualPedestal)te : null;
    }

    public ConstellationEffectProperties createProperties(int mirrors) {
        return new ConstellationEffectProperties((Double)this.getConfig().range.get() + (double)mirrors * (Double)this.getConfig().rangePerLens.get());
    }

    public abstract Config getConfig();

    @Nonnull
    public IWeakConstellation getConstellation() {
        return this.cst;
    }

    @Nonnull
    public ILocatable getPos() {
        return this.pos;
    }

    public void clearCache() {
    }

    public void readFromNBT(CompoundNBT cmp) {
    }

    public void writeToNBT(CompoundNBT cmp) {
    }

    @Nullable
    public PlayerEntity getOwningPlayerInWorld(World world, BlockPos pos) {
        TileRitualPedestal pedestal = this.getPedestal(world, pos);
        if (pedestal != null) {
            return pedestal.getOwner();
        }
        return null;
    }

    public static abstract class Config
    extends ConfigEntry {
        private final boolean defaultEnabled = true;
        private final double defaultRange;
        private final double defaultRangePerLens;
        public ForgeConfigSpec.BooleanValue enabled;
        public ForgeConfigSpec.DoubleValue range;
        public ForgeConfigSpec.DoubleValue rangePerLens;

        public Config(String constellationName, double defaultRange, double defaultRangePerLens) {
            super(String.format("constellation.effect.%s", constellationName));
            this.defaultRange = defaultRange;
            this.defaultRangePerLens = defaultRangePerLens;
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.enabled = cfgBuilder.comment("Set this to false to disable this ritual effect").translation(this.translationKey("enabled")).define("enabled", this.defaultEnabled);
            this.range = cfgBuilder.comment("Defines the radius (in blocks) in which the ritual will allow the players to fly in.").translation(this.translationKey("range")).defineInRange("range", this.defaultRange, 1.0, 512.0);
            this.rangePerLens = cfgBuilder.comment("Defines the increase in radius the ritual will get per active lens enhancing the ritual.").translation(this.translationKey("rangePerLens")).defineInRange("rangePerLens", this.defaultRangePerLens, 0.0, 128.0);
        }
    }
}

