/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.auxiliary.CropHelper;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectAevitas
extends CEffectAbstractList<CropHelper.GrowablePlant> {
    public static AevitasConfig CONFIG = new AevitasConfig();

    public CEffectAevitas(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.aevitas, (Integer)CEffectAevitas.CONFIG.maxAmount.get(), (world, pos, state) -> CropHelper.wrapPlant((IWorld)world, pos) != null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        if (rand.nextBoolean()) {
            ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3((double)pos.func_177958_n() + (double)rand.nextFloat() * (prop.getSize() / 2.0) * (double)(rand.nextBoolean() ? 1 : -1) + 0.5, (double)pos.func_177956_o() + (double)rand.nextFloat() * (prop.getSize() / 4.0) + 0.5, (double)pos.func_177952_p() + (double)rand.nextFloat() * (prop.getSize() / 2.0) * (double)(rand.nextBoolean() ? 1 : -1) + 0.5))).setGravityStrength(-0.005f)).setScaleMultiplier(0.45f)).color(VFXColorFunction.constant(ColorsAS.RITUAL_CONSTELLATION_AEVITAS))).setMaxAge(35);
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        boolean changed = false;
        CropHelper.GrowablePlant plant = (CropHelper.GrowablePlant)this.getRandomElementChanced();
        if (plant != null) {
            changed = MiscUtils.executeWithChunk((IWorldReader)world, plant.getPos(), Boolean.valueOf(changed), changedFlag -> {
                if (properties.isCorrupted()) {
                    if (world instanceof ServerWorld) {
                        if (BlockUtils.breakBlockWithoutPlayer((ServerWorld)world, plant.getPos())) {
                            changedFlag = true;
                        }
                    } else if (world.func_217377_a(plant.getPos(), false)) {
                        changedFlag = true;
                    }
                } else if (!plant.isValid((IWorld)world)) {
                    this.removeElement(plant.getPos());
                    changedFlag = true;
                } else if (plant.tryGrow((IWorld)world, rand)) {
                    PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.CROP_GROWTH).addData(buf -> ByteBufUtils.writeVector(buf, new Vector3((Vec3i)plant.getPos())));
                    PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)world, (Vec3i)plant.getPos(), 16.0));
                    changedFlag = true;
                }
                return changedFlag;
            }, false);
        }
        if (this.findNewPosition(world, pos, properties) != null) {
            changed = true;
        }
        if (this.findNewPosition(world, pos, properties) != null) {
            changed = true;
        }
        int amplifier = (Integer)CEffectAevitas.CONFIG.potionAmplifier.get();
        List entities = world.func_217357_a(LivingEntity.class, BOX.func_186670_a(pos).func_186662_g(properties.getSize()));
        for (LivingEntity entity : entities) {
            if (!entity.func_70089_S()) continue;
            if (properties.isCorrupted()) {
                entity.func_195064_c(new EffectInstance((Effect)EffectsAS.EFFECT_BLEED, 200, amplifier * 2));
                entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, amplifier * 3));
                entity.func_195064_c(new EffectInstance(Effects.field_76438_s, 200, amplifier * 4));
                entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, amplifier * 2));
                continue;
            }
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, amplifier));
        }
        return changed;
    }

    @Override
    @Nullable
    public CropHelper.GrowablePlant recreateElement(CompoundNBT tag, BlockPos pos) {
        return CropHelper.fromNBT(tag, pos);
    }

    @Override
    @Nullable
    public CropHelper.GrowablePlant createElement(World world, BlockPos pos) {
        return CropHelper.wrapPlant((IWorld)world, pos);
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playParticles(PktPlayEffect event) {
        Vector3 at = ByteBufUtils.readVector(event.getExtraData());
        for (int i = 0; i < 8; ++i) {
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at.clone().add((double)rand.nextFloat(), 0.2, (double)rand.nextFloat()))).setMotion(new Vector3(0.0, 0.005 + (double)rand.nextFloat() * 0.01, 0.0))).setScaleMultiplier(0.1f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.constant(Color.GREEN));
        }
    }

    private static class AevitasConfig
    extends CEffectAbstractList.CountConfig {
        private final int defaultPotionAmplifier = 1;
        public ForgeConfigSpec.IntValue potionAmplifier;

        public AevitasConfig() {
            super("aevitas", 10.0, 4.0, 200);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.potionAmplifier = cfgBuilder.comment("Set the amplifier for the potion effects this ritual provides.").translation(this.translationKey("potionAmplifier")).defineInRange("potionAmplifier", this.defaultPotionAmplifier, 0, 10);
        }
    }
}

