/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ListEntries;
import hellfirepvp.astralsorcery.common.data.config.registry.TileAccelerationBlacklistRegistry;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.time.TimeStopController;
import hellfirepvp.astralsorcery.common.util.time.TimeStopZone;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CEffectHorologium
extends CEffectAbstractList<ListEntries.PosEntry> {
    public static HorologiumConfig CONFIG = new HorologiumConfig();

    public CEffectHorologium(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.horologium, (Integer)CEffectHorologium.CONFIG.maxAmount.get(), (world, pos, state) -> TileAccelerationBlacklistRegistry.INSTANCE.canBeAccelerated(world.func_175625_s(pos)));
    }

    @Override
    @Nullable
    public ListEntries.PosEntry recreateElement(CompoundNBT tag, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @Nullable
    public ListEntries.PosEntry createElement(World world, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
        for (int i = 0; i < 2; ++i) {
            Color c = (Color)MiscUtils.eitherOf(rand, () -> Color.WHITE, () -> ColorsAS.CONSTELLATION_HOROLOGIUM);
            Vector3 at = Vector3.random().normalize().multiply((double)rand.nextFloat() * prop.getSize()).add((Vec3i)pos).add(0.5, 0.5, 0.5);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(c))).setScaleMultiplier(0.3f + rand.nextFloat() * 0.5f)).setMaxAge(40 + rand.nextInt(20));
        }
        if (rand.nextInt(8) == 0) {
            Vector3 rand1 = Vector3.random().normalize().multiply((double)rand.nextFloat() * prop.getSize()).add((Vec3i)pos).add(0.5, 0.5, 0.5);
            Vector3 rand2 = Vector3.random().normalize().multiply((double)rand.nextFloat() * prop.getSize()).add((Vec3i)pos).add(0.5, 0.5, 0.5);
            ((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(rand1)).makeDefault(rand2).color(VFXColorFunction.WHITE);
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        boolean changed = false;
        if (properties.isCorrupted()) {
            TimeStopZone zone = TimeStopController.tryGetZoneAt(world, pos);
            if (zone == null) {
                zone = TimeStopController.freezeWorldAt(TimeStopZone.EntityTargetController.noPlayers(), world, pos, (float)properties.getSize(), 100);
            }
            zone.setTicksToLive(100);
            return true;
        }
        ListEntries.PosEntry entry = (ListEntries.PosEntry)this.getRandomElementChanced();
        if (entry != null && MiscUtils.executeWithChunk((IWorldReader)world, entry.getPos(), () -> {
            TileEntity tile = MiscUtils.getTileAt((IBlockReader)world, entry.getPos(), TileEntity.class, true);
            if (tile != null && TileAccelerationBlacklistRegistry.INSTANCE.canBeAccelerated(tile)) {
                try {
                    long startNs = System.nanoTime();
                    for (int times = 2 + rand.nextInt(4); times > 0; --times) {
                        ((ITickable)tile).func_110550_d();
                        if (System.nanoTime() - startNs >= 80000L) break;
                    }
                }
                catch (Exception exc) {
                    TileAccelerationBlacklistRegistry.INSTANCE.addErrored(tile);
                    this.removeElement(entry);
                    AstralSorcery.log.warn("Couldn't accelerate TileEntity " + tile.getClass().getName() + ".");
                    AstralSorcery.log.warn("Temporarily blacklisting that class. Consider adding that to the blacklist if it persists?");
                    exc.printStackTrace();
                }
            } else {
                this.removeElement(entry);
                return true;
            }
            return false;
        }, false).booleanValue()) {
            changed = true;
        }
        if (this.findNewPosition(world, pos, properties) != null) {
            changed = true;
        }
        return changed;
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    private static class HorologiumConfig
    extends CEffectAbstractList.CountConfig {
        public HorologiumConfig() {
            super("horologium", 6.0, 3.0, 32);
        }
    }
}

