/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.source.orbital.FXOrbitalLucerna;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectStatus;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperSpawnDeny;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.block.WorldBlockPos;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.tick.TickTokenMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CEffectLucerna
extends ConstellationEffect
implements ConstellationEffectStatus {
    public static LucernaConfig CONFIG = new LucernaConfig();
    private int rememberedTimeout = 0;

    public CEffectLucerna(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.lucerna);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        if (ClientScheduler.getClientTick() % 20L == 0L) {
            EffectHelper.spawnSource(new FXOrbitalLucerna(new Vector3((Vec3i)pos).add(0.5, 0.5, 0.5)).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOrbitRadius(0.8 + (double)rand.nextFloat() * 0.7).setTicksPerRotation(20 + rand.nextInt(20)));
        }
    }

    @Override
    public boolean runStatusEffect(World world, BlockPos pos, int mirrorAmount, ConstellationEffectProperties modified, @Nullable IMinorConstellation possibleTraitEffect) {
        if (modified.isCorrupted()) {
            if (DayTimeHelper.isNight(world) && rand.nextBoolean()) {
                SkyHandler.getInstance().revertWorldTimeTick(world);
            }
            return true;
        }
        WorldBlockPos at = WorldBlockPos.wrapServer(world, pos);
        TickTokenMap.SimpleTickToken token = (TickTokenMap.SimpleTickToken)EventHelperSpawnDeny.spawnDenyRegions.get((Object)at);
        if (token != null && Math.abs((Double)token.getValue() - modified.getSize()) < 0.001) {
            int next = token.getRemainingTimeout() + 80;
            if (next > 400) {
                next = 400;
            }
            token.setTimeout(next);
            this.rememberedTimeout = next;
        } else {
            if (token != null) {
                token.setTimeout(0);
            }
            this.rememberedTimeout = Math.min(400, this.rememberedTimeout + 80);
            EventHelperSpawnDeny.spawnDenyRegions.put(at, new TickTokenMap.SimpleTickToken<Double>(modified.getSize(), this.rememberedTimeout));
        }
        return true;
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        return false;
    }

    @Override
    public void readFromNBT(CompoundNBT cmp) {
        super.readFromNBT(cmp);
        this.rememberedTimeout = cmp.func_74762_e("rememberedTimeout");
    }

    @Override
    public void writeToNBT(CompoundNBT cmp) {
        super.writeToNBT(cmp);
        cmp.func_74768_a("rememberedTimeout", this.rememberedTimeout);
    }

    private static class LucernaConfig
    extends ConstellationEffect.Config {
        public LucernaConfig() {
            super("lucerna", 32.0, 64.0);
        }
    }
}

