/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.source.orbital.FXOrbitalPelotrio;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ListEntries;
import hellfirepvp.astralsorcery.common.data.config.registry.EntityTransmutationRegistry;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectPelotrio
extends CEffectAbstractList<ListEntries.EntitySpawnEntry> {
    private static AxisAlignedBB PROXIMITY_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static PelotrioConfig CONFIG = new PelotrioConfig();

    public CEffectPelotrio(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.pelotrio, (Integer)CEffectPelotrio.CONFIG.maxAmount.get(), (world, pos, state) -> ListEntries.EntitySpawnEntry.createEntry(world, pos, SpawnReason.SPAWNER) != null);
    }

    @Override
    @Nullable
    public ListEntries.EntitySpawnEntry recreateElement(CompoundNBT tag, BlockPos pos) {
        return null;
    }

    @Override
    @Nullable
    public ListEntries.EntitySpawnEntry createElement(World world, BlockPos pos) {
        return ListEntries.EntitySpawnEntry.createEntry(world, pos, SpawnReason.SPAWNER);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
        if (rand.nextFloat() < 0.2f) {
            Vector3 at = Vector3.random().normalize().multiply((double)rand.nextFloat() * prop.getSize()).add((Vec3i)pos).add(0.5, 0.5, 0.5);
            EffectHelper.spawnSource(new FXOrbitalPelotrio(at).setOrbitAxis(Vector3.random()).setOrbitRadius(0.8 + (double)rand.nextFloat() * 0.7).setTicksPerRotation(20 + rand.nextInt(20)));
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        boolean update = false;
        List nearbyEntities = world.func_217357_a(LivingEntity.class, PROXIMITY_BOX.func_186670_a(pos).func_186662_g(properties.getSize()));
        if (properties.isCorrupted()) {
            for (LivingEntity entity : nearbyEntities) {
                LivingEntity transmuted;
                if (entity == null || !entity.func_70089_S() || rand.nextInt(300) != 0 || (transmuted = EntityTransmutationRegistry.INSTANCE.transmuteEntity((ServerWorld)world, entity)) == null) continue;
                transmuted.func_195064_c(new EffectInstance((Effect)EffectsAS.EFFECT_DROP_MODIFIER, Integer.MAX_VALUE, 2));
                AstralSorcery.getProxy().scheduleDelayed(() -> world.func_217376_c((Entity)transmuted));
                update = true;
            }
            return update;
        }
        ListEntries.EntitySpawnEntry entry = (ListEntries.EntitySpawnEntry)this.getRandomElementChanced();
        if (entry != null) {
            int count = entry.getCounter();
            entry.setCounter(++count);
            if (count >= 40) {
                entry.spawn(world, SpawnReason.SPAWNER);
                this.removeElement(entry);
            }
            update = true;
        }
        if (nearbyEntities.size() > (Integer)CEffectPelotrio.CONFIG.proximityAmount.get()) {
            return update;
        }
        if ((double)rand.nextFloat() < (Double)CEffectPelotrio.CONFIG.spawnChance.get() && this.findNewPosition(world, pos, properties) != null) {
            update = true;
        }
        return update;
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    private static class PelotrioConfig
    extends CEffectAbstractList.CountConfig {
        private final double defaultSpawnChance = 0.05;
        private final int defaultProximityAmount = 24;
        public ForgeConfigSpec.DoubleValue spawnChance;
        public ForgeConfigSpec.IntValue proximityAmount;

        public PelotrioConfig() {
            super("pelotrio", 12.0, 0.0, 5);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.spawnChance = cfgBuilder.comment("Defines the per-tick chance that a new position for a entity-spawn will be searched for.").translation(this.translationKey("spawnChance")).defineInRange("spawnChance", this.defaultSpawnChance, 0.0, 1.0);
            this.proximityAmount = cfgBuilder.comment("Defines the threshold at which the ritual will stop spawning mobs. If there are more or equal amount of mobs near this ritual, the ritual will not spawn more mobs. Mainly to reduce potential server lag.").translation(this.translationKey("proximityAmount")).defineInRange("proximityAmount", this.defaultProximityAmount, 0, 256);
        }
    }
}

