/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.base;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.lib.StructuresAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockPositionGenerator;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockRandomPositionGenerator;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class CEffectAbstractList<T extends ListEntry>
extends ConstellationEffect {
    protected boolean isLinkedRitual = false;
    private boolean excludesRitual = false;
    private boolean excludeRitualColumn = false;
    protected final BlockPredicate verifier;
    protected final int maxAmount;
    private final BlockPositionGenerator positionStrategy;
    private List<T> elements = new ArrayList<T>();

    protected CEffectAbstractList(@Nonnull ILocatable origin, @Nonnull IWeakConstellation cst, int maxAmount, BlockPredicate verifier) {
        super(origin, cst);
        this.maxAmount = maxAmount;
        this.verifier = verifier;
        this.positionStrategy = this.createPositionStrategy();
    }

    protected void excludeRitualPositions() {
        this.setChunkNeedsToBeLoaded();
        if (!this.excludesRitual) {
            this.excludesRitual = true;
            this.positionStrategy.andFilter(this.createExcludeRitualPredicate());
        }
    }

    protected void excludeRitualColumn() {
        this.setChunkNeedsToBeLoaded();
        if (!this.excludeRitualColumn) {
            this.excludeRitualColumn = true;
            this.positionStrategy.andFilter(this.createExcludeRitualColumnPredicate());
        }
    }

    protected void selectSphericalPositions() {
        this.positionStrategy.andFilter((pos, radius) -> {
            double dst = new Vector3((Vec3i)this.getPos().getLocationPos()).add(0.5, 0.5, 0.5).distanceSquared(new Vector3((Vec3i)pos).add((Vec3i)this.getPos().getLocationPos()).add(0.5, 0.5, 0.5));
            return dst <= radius * radius;
        });
    }

    @Nullable
    public abstract T recreateElement(CompoundNBT var1, BlockPos var2);

    @Nullable
    public abstract T createElement(World var1, BlockPos var2);

    @Nonnull
    protected BlockPositionGenerator createPositionStrategy() {
        return new BlockRandomPositionGenerator();
    }

    @Nonnull
    protected BlockPositionGenerator selectPositionStrategy(BlockPositionGenerator defaultGenerator, ConstellationEffectProperties properties) {
        return defaultGenerator;
    }

    private Predicate<BlockPos> createExcludeRitualPredicate() {
        return pos -> !pos.equals((Object)BlockPos.field_177992_a) && this.isLinkedRitual || !pos.equals((Object)TileRitualPedestal.RITUAL_ANCHOR_OFFEST) && (pos.func_177956_o() >= 3 || !StructuresAS.STRUCT_RITUAL_PEDESTAL.hasBlockAt(pos) && !StructuresAS.STRUCT_RITUAL_PEDESTAL.hasBlockAt(pos.func_177977_b()) && !StructuresAS.STRUCT_RITUAL_PEDESTAL.hasBlockAt(pos.func_177979_c(2)) && !StructuresAS.STRUCT_RITUAL_PEDESTAL.hasBlockAt(pos.func_177979_c(3)));
    }

    private Predicate<BlockPos> createExcludeRitualColumnPredicate() {
        return pos -> this.isLinkedRitual && pos.func_177958_n() == 0 && pos.func_177952_p() == 0 || !this.isLinkedRitual && StructuresAS.STRUCT_RITUAL_PEDESTAL.hasBlockAt(new BlockPos(pos.func_177958_n(), -1, pos.func_177952_p()));
    }

    public int getCount() {
        return this.elements.size();
    }

    public void clear() {
        this.elements.clear();
    }

    @Nullable
    public T getRandomElement() {
        return (T)((ListEntry)MiscUtils.getRandomEntry(this.elements, rand));
    }

    @Nullable
    public T getRandomElementChanced() {
        if (this.elements.isEmpty()) {
            return null;
        }
        if (rand.nextInt(Math.max(0, (this.maxAmount - this.getCount()) / 4) + 1) == 0) {
            return this.getRandomElement();
        }
        return null;
    }

    @Nullable
    public T peekNewPosition(World world, BlockPos pos, ConstellationEffectProperties prop) {
        BlockPositionGenerator gen;
        if (this.excludesRitual || this.excludeRitualColumn) {
            MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
                this.isLinkedRitual = MiscUtils.getTileAt((IBlockReader)world, pos, TileRitualLink.class, true) != null;
            });
        }
        if ((gen = this.selectPositionStrategy(this.positionStrategy, prop)) != this.positionStrategy) {
            gen.copyFilterFrom(this.positionStrategy);
        }
        BlockPos at = gen.generateNextPosition(BlockPos.field_177992_a, prop.getSize());
        BlockPos actual = at.func_177971_a((Vec3i)pos);
        return (T)MiscUtils.executeWithChunk((IWorldReader)world, actual, () -> {
            if (this.verifier.test(world, actual, world.func_180495_p(actual))) {
                return this.createElement(world, actual);
            }
            return null;
        });
    }

    @Nullable
    public T findNewPosition(World world, BlockPos pos, ConstellationEffectProperties prop) {
        if (this.getCount() >= this.maxAmount) {
            return null;
        }
        T newElement = this.peekNewPosition(world, pos, prop);
        if (newElement != null && !this.hasElement(newElement.getPos())) {
            this.elements.add(newElement);
            return newElement;
        }
        return null;
    }

    public boolean removeElement(T entry) {
        return this.removeElement(entry.getPos());
    }

    public boolean removeElement(BlockPos pos) {
        return this.elements.removeIf(e -> e.getPos().equals((Object)pos));
    }

    public boolean hasElement(BlockPos pos) {
        return MiscUtils.contains(this.elements, e -> e.getPos().equals((Object)pos));
    }

    @Override
    public void readFromNBT(CompoundNBT cmp) {
        super.readFromNBT(cmp);
        this.elements.clear();
        ListNBT list = cmp.func_150295_c("elements", 10);
        for (INBT nbt : list) {
            CompoundNBT tag = (CompoundNBT)nbt;
            BlockPos pos = NBTHelper.readBlockPosFromNBT(tag);
            CompoundNBT tagData = tag.func_74775_l("data");
            T element = this.recreateElement(tagData, pos);
            if (element == null) continue;
            element.readFromNBT(tagData);
            this.elements.add(element);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT cmp) {
        super.writeToNBT(cmp);
        ListNBT list = new ListNBT();
        for (ListEntry element : this.elements) {
            CompoundNBT tag = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(element.getPos(), tag);
            CompoundNBT dataTag = new CompoundNBT();
            element.writeToNBT(dataTag);
            tag.func_218657_a("data", (INBT)dataTag);
            list.add((Object)tag);
        }
        cmp.func_218657_a("elements", (INBT)list);
    }

    public static class CountConfig
    extends ConstellationEffect.Config {
        private final int defaultMaxAmount;
        public ForgeConfigSpec.IntValue maxAmount;

        public CountConfig(String constellationName, double defaultRange, double defaultRangePerLens, int defaultMaxAmount) {
            super(constellationName, defaultRange, defaultRangePerLens);
            this.defaultMaxAmount = defaultMaxAmount;
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.maxAmount = cfgBuilder.comment("Defines the amount of blocks this ritual will try to capture at most.").translation(this.translationKey("maxAmount")).defineInRange("maxAmount", this.defaultMaxAmount, 1, 2048);
        }
    }

    public static interface ListEntry {
        public BlockPos getPos();

        public void writeToNBT(CompoundNBT var1);

        public void readFromNBT(CompoundNBT var1);
    }
}

