/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.engraving;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.perk.DynamicModifierHelper;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.BookItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EngravingEffect
extends ForgeRegistryEntry<EngravingEffect> {
    private List<ApplicableEffect> effects = new ArrayList<ApplicableEffect>();

    public EngravingEffect(IConstellation cst) {
        this.setRegistryName(cst.getRegistryName());
    }

    public EngravingEffect addEffect(ApplicableEffect potion) {
        this.effects.add(potion);
        return this;
    }

    public List<ApplicableEffect> getApplicableEffects(@Nonnull ItemStack stack) {
        return this.effects.stream().filter(effects -> effects.supports(stack)).collect(Collectors.toList());
    }

    public static class PotionEffect
    implements ApplicableEffect {
        private final Supplier<Effect> effect;
        private final int min;
        private final int max;

        public PotionEffect(Supplier<Effect> effect, int min, int max) {
            this.effect = effect;
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean supports(@Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (!(stack.func_77973_b() instanceof PotionItem)) {
                return false;
            }
            return !MiscUtils.contains(PotionUtils.func_185189_a((ItemStack)stack), effInstance -> effInstance.func_188419_a().equals(this.effect.get()));
        }

        @Override
        public ItemStack apply(@Nonnull ItemStack stack, float percent, Random rand) {
            int amp = this.min + Math.round(percent * (float)Math.max(0, this.max - this.min));
            int dur = 3600 + Math.round(rand.nextFloat() * 4.0f * 60.0f * 20.0f);
            EffectInstance effectInstance = new EffectInstance(this.effect.get(), dur, amp, true, false, true);
            List existing = PotionUtils.func_185189_a((ItemStack)stack);
            existing.add(effectInstance);
            if (!MiscUtils.contains(existing, effInstance -> effInstance.func_188419_a().equals((Object)EffectsAS.EFFECT_CHEAT_DEATH)) && rand.nextInt(30) == 0) {
                existing.add(new EffectInstance((Effect)EffectsAS.EFFECT_CHEAT_DEATH, 3600 + Math.round(rand.nextFloat() * 4.0f * 60.0f * 20.0f), 0, true, false, true));
            }
            PotionUtils.func_185184_a((ItemStack)stack, (Collection)existing);
            stack.func_77978_p().func_74768_a("CustomPotionColor", ColorsAS.DYE_ORANGE.getRGB());
            stack.func_200302_a(new TranslationTextComponent("potion.astralsorcery.crafted.name", new Object[0]).func_211708_a(TextFormatting.GOLD));
            return stack;
        }
    }

    public static class EnchantmentEffect
    implements ApplicableEffect {
        private final Supplier<Enchantment> enchantment;
        private final int min;
        private final int max;
        private boolean ignoreCompat = false;

        public EnchantmentEffect(Supplier<Enchantment> enchantment, int min, int max) {
            this.enchantment = enchantment;
            this.min = min;
            this.max = max;
        }

        public EnchantmentEffect setIgnoreCompatibility() {
            this.ignoreCompat = true;
            return this;
        }

        @Override
        public boolean supports(@Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (stack.func_77973_b() instanceof BookItem) {
                return this.enchantment.get().isAllowedOnBooks();
            }
            if (!(stack.func_77973_b() instanceof EnchantedBookItem) && !this.enchantment.get().func_92089_a(stack)) {
                return false;
            }
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            Enchantment toApply = this.enchantment.get();
            for (Enchantment applied : enchantments.keySet()) {
                if (toApply.equals(applied)) {
                    return false;
                }
                if (this.ignoreCompat || !toApply.func_191560_c(applied) || stack.func_77973_b() instanceof EnchantedBookItem) continue;
                return false;
            }
            return true;
        }

        @Override
        public ItemStack apply(@Nonnull ItemStack stack, float percent, Random rand) {
            int level = this.min + Math.round(percent * (float)Math.max(0, this.max - this.min));
            if (stack.func_77973_b() instanceof BookItem) {
                stack = ItemUtils.changeItem(stack, Items.field_151134_bR);
            }
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchantments.put(this.enchantment.get(), level);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
            return stack;
        }
    }

    public static class ModifierEffect
    implements ApplicableEffect {
        private final Supplier<PerkAttributeType> modifier;
        private final ModifierType type;
        private final float min;
        private final float max;
        private final List<EnchantmentType> applicableTypes = new ArrayList<EnchantmentType>();
        private boolean formatToInteger = false;

        public ModifierEffect(Supplier<PerkAttributeType> modifier, ModifierType type, float min, float max) {
            this.modifier = modifier;
            this.type = type;
            this.min = min;
            this.max = max;
        }

        public ModifierEffect addApplicableType(EnchantmentType type) {
            this.applicableTypes.add(type);
            return this;
        }

        public ModifierEffect formatResultAsInteger() {
            this.formatToInteger = true;
            return this;
        }

        @Override
        public boolean supports(@Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (!DynamicModifierHelper.getStaticModifiers(stack).isEmpty()) {
                return false;
            }
            if (this.applicableTypes.isEmpty()) {
                return EnchantmentType.ALL.func_77557_a(stack.func_77973_b());
            }
            for (EnchantmentType type : this.applicableTypes) {
                if (!type.func_77557_a(stack.func_77973_b())) continue;
                return true;
            }
            return false;
        }

        @Override
        public ItemStack apply(@Nonnull ItemStack stack, float percent, Random rand) {
            float rValue = percent * Math.max(0.0f, this.max - this.min);
            if (this.formatToInteger) {
                rValue = Math.round(rValue);
            }
            DynamicModifierHelper.addModifier(stack, UUID.randomUUID(), this.modifier.get(), this.type, this.min + rValue);
            return stack;
        }
    }

    public static interface ApplicableEffect {
        public boolean supports(@Nonnull ItemStack var1);

        public ItemStack apply(@Nonnull ItemStack var1, float var2, Random var3);
    }
}

