/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectAevitas
extends MantleEffect {
    public static AevitasConfig CONFIG = new AevitasConfig();

    public MantleEffectAevitas() {
        super(ConstellationsAS.aevitas);
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    protected void tickServer(PlayerEntity player) {
        FoodStats stats;
        super.tickServer(player);
        World world = player.func_130014_f_();
        BlockPos playerPos = player.func_180425_c();
        for (int xx = -3; xx <= 3; ++xx) {
            for (int zz = -3; zz <= 3; ++zz) {
                BlockPos at = playerPos.func_177982_a(xx, -1, zz);
                MiscUtils.executeWithChunk((IWorldReader)world, at, () -> {
                    if (world.func_180495_p(at).isAir((IBlockReader)world, at) && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectAevitas.CONFIG.chargeCostPerBlock.get()).intValue()) && world.func_175656_a(at, BlocksAS.VANISHING.func_176223_P())) {
                        AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectAevitas.CONFIG.chargeCostPerBlock.get()).intValue(), false);
                    }
                });
            }
        }
        int healChance = (Integer)MantleEffectAevitas.CONFIG.healChance.get();
        int foodChance = (Integer)MantleEffectAevitas.CONFIG.feedChance.get();
        if (healChance > 0 && rand.nextInt(healChance) == 0) {
            player.func_70691_i(((Double)MantleEffectAevitas.CONFIG.healthPerCycle.get()).floatValue());
        }
        if (foodChance > 0 && rand.nextInt(foodChance) == 0 && ((stats = player.func_71024_bL()).func_75116_a() < 20 || stats.func_75115_e() < 5.0f) && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectAevitas.CONFIG.chargeCostPerFood.get()).intValue())) {
            stats.func_75122_a(((Double)MantleEffectAevitas.CONFIG.foodPerCycle.get()).intValue() / 2, ((Double)MantleEffectAevitas.CONFIG.foodPerCycle.get()).floatValue());
            AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectAevitas.CONFIG.chargeCostPerFood.get()).intValue(), false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        this.playCapeSparkles(player, 0.1f);
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static class AevitasConfig
    extends MantleEffect.Config {
        private final int defaultHealChance = 20;
        private final int defaultFeedChance = 40;
        private final double defaultHealthPerCycle = 0.25;
        private final double defaultFoodPerCycle = 0.5;
        private final int defaultChargeCostPerBlock = 2;
        private final int defaultChargeCostPerHeal = 15;
        private final int defaultChargeCostPerFood = 15;
        public ForgeConfigSpec.IntValue healChance;
        public ForgeConfigSpec.IntValue feedChance;
        public ForgeConfigSpec.DoubleValue healthPerCycle;
        public ForgeConfigSpec.DoubleValue foodPerCycle;
        public ForgeConfigSpec.IntValue chargeCostPerBlock;
        public ForgeConfigSpec.IntValue chargeCostPerHeal;
        public ForgeConfigSpec.IntValue chargeCostPerFood;

        public AevitasConfig() {
            super("aevitas");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.healChance = cfgBuilder.comment("Set the chance of '1 in <this value>' per tick to do 1 heal cycle. Amount healed per cycle is determined by 'healthPerCycle' config option. Set to 0 to disable.").translation(this.translationKey("healChance")).defineInRange("healChance", this.defaultHealChance, 0, Integer.MAX_VALUE);
            this.feedChance = cfgBuilder.comment("Set the chance of '1 in <this value>' per tick to do 1 food cycle. Amount fed per cycle is determined by 'foodPerCycle' config option. Set to 0 to disable.").translation(this.translationKey("feedChance")).defineInRange("feedChance", this.defaultFeedChance, 0, Integer.MAX_VALUE);
            this.healthPerCycle = cfgBuilder.comment("Set the amount of health recovered by health cycle.").translation(this.translationKey("healthPerCycle")).defineInRange("healthPerCycle", this.defaultHealthPerCycle, 0.0, 100.0);
            this.foodPerCycle = cfgBuilder.comment("Set the amount of food recovered by food cycle.").translation(this.translationKey("foodPerCycle")).defineInRange("foodPerCycle", this.defaultFoodPerCycle, 0.0, 100.0);
            this.chargeCostPerBlock = cfgBuilder.comment("Set the amount alignment charge consumed per block placed").translation(this.translationKey("chargeCostPerBlock")).defineInRange("chargeCostPerBlock", this.defaultChargeCostPerBlock, 0, 1000);
            ForgeConfigSpec.Builder builder = cfgBuilder.comment("Set the amount alignment charge consumed per feed-cycle").translation(this.translationKey("chargeCostPerFood"));
            this.getClass();
            this.chargeCostPerFood = builder.defineInRange("chargeCostPerFood", 15, 0, 1000);
            ForgeConfigSpec.Builder builder2 = cfgBuilder.comment("Set the amount alignment charge consumed per heal-cycle").translation(this.translationKey("chargeCostPerHeal"));
            this.getClass();
            this.chargeCostPerHeal = builder2.defineInRange("chargeCostPerHeal", 15, 0, 1000);
        }
    }
}

