/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.world;

import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import net.minecraft.world.World;

public class DayTimeHelper {
    public static float getCurrentDaytimeDistribution(World world) {
        int dLength = (Integer)GeneralConfig.CONFIG.dayLength.get();
        float dayPart = (world.func_72820_D() % (long)dLength + (long)dLength) % (long)dLength;
        if (dayPart < (float)dLength / 2.0f) {
            return 0.0f;
        }
        float part = (float)dLength / 7.0f;
        if (dayPart < (float)dLength / 2.0f + part) {
            return (dayPart - ((float)dLength / 2.0f + part)) / part + 1.0f;
        }
        if (dayPart > (float)dLength - part) {
            return 1.0f - (dayPart - ((float)dLength - part)) / part;
        }
        return 1.0f;
    }

    public static boolean isNight(World world) {
        return (double)DayTimeHelper.getCurrentDaytimeDistribution(world) >= 0.55;
    }

    public static boolean isDay(World world) {
        return (double)DayTimeHelper.getCurrentDaytimeDistribution(world) <= 0.05;
    }

    public static int getSolarEclipseHalfDuration() {
        return (Integer)GeneralConfig.CONFIG.dayLength.get() / 10;
    }

    public static int getLunarEclipseHalfDuration() {
        return (Integer)GeneralConfig.CONFIG.dayLength.get() / 10;
    }
}

