/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.container.factory;

import hellfirepvp.astralsorcery.common.container.ContainerAltarTrait;
import hellfirepvp.astralsorcery.common.container.factory.CustomContainerProvider;
import hellfirepvp.astralsorcery.common.lib.ContainerTypesAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.IContainerFactory;

public class ContainerAltarRadianceProvider
extends CustomContainerProvider<ContainerAltarTrait> {
    private final TileAltar ta;

    public ContainerAltarRadianceProvider(TileAltar ta) {
        super(ContainerTypesAS.ALTAR_RADIANCE);
        this.ta = ta;
    }

    @Override
    protected void writeExtraData(PacketBuffer buf) {
        ByteBufUtils.writePos(buf, this.ta.func_174877_v());
    }

    @Override
    @Nonnull
    public ContainerAltarTrait createMenu(int id, PlayerInventory plInventory, PlayerEntity player) {
        return new ContainerAltarTrait(this.ta, plInventory, id);
    }

    private static ContainerAltarTrait createFromPacket(int id, PlayerInventory plInventory, PacketBuffer data) {
        BlockPos at = ByteBufUtils.readPos(data);
        PlayerEntity player = plInventory.field_70458_d;
        TileAltar ta = MiscUtils.getTileAt((IBlockReader)player.func_130014_f_(), at, TileAltar.class, true);
        return new ContainerAltarTrait(ta, plInventory, id);
    }

    public static class Factory
    implements IContainerFactory<ContainerAltarTrait> {
        public ContainerAltarTrait create(int windowId, PlayerInventory inv, PacketBuffer data) {
            return ContainerAltarRadianceProvider.createFromPacket(windowId, inv, data);
        }
    }
}

