/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.container.factory;

import hellfirepvp.astralsorcery.common.container.ContainerTome;
import hellfirepvp.astralsorcery.common.container.factory.CustomContainerProvider;
import hellfirepvp.astralsorcery.common.lib.ContainerTypesAS;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.IContainerFactory;

public class ContainerTomeProvider
extends CustomContainerProvider<ContainerTome> {
    private ItemStack stackTome;
    private int slotTome;

    public ContainerTomeProvider(ItemStack stackTome, int slotTome) {
        super(ContainerTypesAS.TOME);
        this.stackTome = stackTome;
        this.slotTome = slotTome;
    }

    @Override
    protected void writeExtraData(PacketBuffer buf) {
        ByteBufUtils.writeItemStack(buf, this.stackTome);
        buf.writeInt(this.slotTome);
    }

    @Override
    @Nonnull
    public ContainerTome createMenu(int id, PlayerInventory plInventory, PlayerEntity player) {
        return new ContainerTome(id, plInventory, player, this.stackTome, this.slotTome);
    }

    private static ContainerTome createFromPacket(int id, PlayerInventory plInventory, PacketBuffer data) {
        ItemStack tome = ByteBufUtils.readItemStack(data);
        int slot = data.readInt();
        return new ContainerTome(id, plInventory, plInventory.field_70458_d, tome, slot);
    }

    public static class Factory
    implements IContainerFactory<ContainerTome> {
        public ContainerTome create(int windowId, PlayerInventory inv, PacketBuffer data) {
            return ContainerTomeProvider.createFromPacket(windowId, inv, data);
        }
    }
}

