/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.custom;

import hellfirepvp.astralsorcery.common.item.wand.ItemIlluminationWand;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeChangeWandColor
extends SpecialRecipe {
    public RecipeChangeWandColor(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.tryFindValidRecipeAndDye(inv) != null;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        DyeColor color = this.tryFindValidRecipeAndDye(inv);
        if (color == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack wand = new ItemStack((IItemProvider)ItemsAS.ILLUMINATION_WAND);
        ItemIlluminationWand.setConfiguredColor(wand, color);
        return wand;
    }

    @Nullable
    private DyeColor tryFindValidRecipeAndDye(CraftingInventory inv) {
        boolean foundWand = false;
        DyeColor dyeColorFound = null;
        int nonEmptyItemsFound = 0;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack in = inv.func_70301_a(slot);
            if (in.func_190926_b()) continue;
            ++nonEmptyItemsFound;
            if (in.func_77973_b() instanceof ItemIlluminationWand) {
                foundWand = true;
                continue;
            }
            DyeColor color = DyeColor.getColor((ItemStack)in);
            if (color == null) continue;
            dyeColorFound = color;
        }
        if (!foundWand || dyeColorFound == null || nonEmptyItemsFound != 2) {
            return null;
        }
        return dyeColorFound;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializersAS.CUSTOM_CHANGE_WAND_COLOR_SERIALIZER;
    }

    public static class Serializer
    extends SpecialRecipeSerializer<RecipeChangeWandColor> {
        public Serializer() {
            super(RecipeChangeWandColor::new);
            this.setRegistryName(RecipeSerializersAS.CUSTOM_CHANGE_WAND_COLOR);
        }
    }
}

