/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.lib.IngredientSerializersAS;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidIngredient
extends Ingredient {
    private final List<FluidStack> fluids;
    private IntList itemIds = null;
    private ItemStack[] itemArray = null;
    private int cacheItemStacks = -1;
    private int cacheItemIds = -1;

    public FluidIngredient(List<FluidStack> fluidStacks) {
        super(Stream.empty());
        this.fluids = fluidStacks;
    }

    public FluidIngredient(FluidStack ... fluidStacks) {
        super(Stream.empty());
        this.fluids = Arrays.asList(fluidStacks);
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public ItemStack[] func_193365_a() {
        if (this.itemArray == null || this.cacheItemStacks != this.fluids.size()) {
            NonNullList lst = NonNullList.func_191196_a();
            for (FluidStack fluid : this.fluids) {
                lst.add((Object)FluidUtil.getFilledBucket((FluidStack)fluid));
            }
            this.itemArray = (ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]);
            this.cacheItemStacks = this.fluids.size();
        }
        return this.itemArray;
    }

    public IntList func_194139_b() {
        if (this.itemIds == null || this.cacheItemIds != this.fluids.size()) {
            this.itemIds = new IntArrayList(this.fluids.size());
            for (FluidStack fluid : this.fluids) {
                ItemStack bucketFluid = FluidUtil.getFilledBucket((FluidStack)fluid);
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)bucketFluid));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
            this.cacheItemIds = this.fluids.size();
        }
        return this.itemIds;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        FluidStack contained = (FluidStack)FluidUtil.getFluidContained((ItemStack)input).orElse((Object)FluidStack.EMPTY);
        if (contained.isEmpty() || contained.getFluid() == null || contained.getAmount() <= 0) {
            return false;
        }
        for (FluidStack target : this.fluids) {
            if (!contained.containsFluid(target)) continue;
            return true;
        }
        return false;
    }

    public boolean func_203189_d() {
        return this.fluids.isEmpty();
    }

    protected void invalidate() {
        super.invalidate();
        this.itemIds = null;
        this.itemArray = null;
    }

    public boolean isSimple() {
        return false;
    }

    public JsonElement func_200304_c() {
        JsonObject object = new JsonObject();
        object.addProperty("type", CraftingHelper.getID(IngredientSerializersAS.FLUID_SERIALIZER).toString());
        JsonArray array = new JsonArray();
        for (FluidStack stack : this.fluids) {
            JsonObject fluidStackObject = new JsonObject();
            fluidStackObject.addProperty("fluid", stack.getFluid().getRegistryName().toString());
            fluidStackObject.addProperty("amount", (Number)stack.getAmount());
            array.add((JsonElement)fluidStackObject);
        }
        object.add("fluid", (JsonElement)array);
        return object;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializersAS.FLUID_SERIALIZER;
    }
}

