/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.attunement;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationItem;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.active.ActiveCrystalAttunementRecipe;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCrystalBase;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class AttuneCrystalRecipe
extends AttunementRecipe<ActiveCrystalAttunementRecipe> {
    private static final AxisAlignedBB BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public AttuneCrystalRecipe() {
        super(AstralSorcery.key("attune_crystal"));
    }

    @Override
    public boolean canStartCrafting(TileAttunementAltar altar) {
        World world = altar.func_145831_w();
        if (DayTimeHelper.isNight(world)) {
            return AttuneCrystalRecipe.findApplicableCrystal(altar) != null;
        }
        return false;
    }

    @Override
    @Nonnull
    public ActiveCrystalAttunementRecipe createRecipe(TileAttunementAltar altar) {
        ItemEntity crystal = AttuneCrystalRecipe.findApplicableCrystal(altar);
        return new ActiveCrystalAttunementRecipe(this, altar.getActiveConstellation(), crystal.func_145782_y());
    }

    @Override
    @Nonnull
    public ActiveCrystalAttunementRecipe deserialize(TileAttunementAltar altar, CompoundNBT nbt, @Nullable ActiveCrystalAttunementRecipe previousInstance) {
        return new ActiveCrystalAttunementRecipe(this, nbt);
    }

    @Nullable
    private static ItemEntity findApplicableCrystal(TileAttunementAltar altar) {
        ItemEntity item;
        IConstellation cst = altar.getActiveConstellation();
        if (cst == null) {
            return null;
        }
        AxisAlignedBB boxAt = BOX.func_186670_a(altar.func_174877_v().func_177984_a()).func_186662_g(1.0);
        Vector3 thisVec = new Vector3(altar).add(0.5, 1.5, 0.5);
        List items = altar.func_145831_w().func_217357_a(ItemEntity.class, boxAt);
        if (!items.isEmpty() && AttuneCrystalRecipe.isApplicableCrystal(item = EntityUtils.selectClosest(items, iEntity -> thisVec.distanceSquared(iEntity.func_174791_d())), cst)) {
            return item;
        }
        return null;
    }

    public static boolean isApplicableCrystal(ItemEntity entity, IConstellation cst) {
        ItemStack stack;
        if (entity.func_70089_S() && !(stack = entity.func_92059_d()).func_190926_b() && stack.func_77973_b() instanceof ItemCrystalBase) {
            if (!(stack.func_77973_b() instanceof ConstellationItem)) {
                return cst instanceof IWeakConstellation;
            }
            IWeakConstellation attuned = ((ConstellationItem)stack.func_77973_b()).getAttunedConstellation(stack);
            IMinorConstellation trait = ((ConstellationItem)stack.func_77973_b()).getTraitConstellation(stack);
            if (attuned == null && cst instanceof IWeakConstellation) {
                return true;
            }
            if (trait == null && cst instanceof IMinorConstellation) {
                return true;
            }
        }
        return false;
    }
}

