/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.attunement.active;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.RefreshFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.source.orbital.FXOrbitalCrystalAttunement;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingSprite;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.util.sound.FadeLoopSound;
import hellfirepvp.astralsorcery.client.util.sound.PositionedLoopSound;
import hellfirepvp.astralsorcery.common.constellation.ConstellationItem;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.AttuneCrystalRecipe;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.AttunementRecipe;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCrystalBase;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ActiveCrystalAttunementRecipe
extends AttunementRecipe.Active<AttuneCrystalRecipe> {
    private static final int DURATION_CRYSTAL_ATTUNEMENT = 500;
    private IConstellation constellation;
    private int entityId;
    private Object itemAttuneSound;
    private Object innerOrbital1;
    private Object attunementFlare;

    public ActiveCrystalAttunementRecipe(AttuneCrystalRecipe recipe, IConstellation constellation, int crystalEntityId) {
        super(recipe);
        this.constellation = constellation;
        this.entityId = crystalEntityId;
    }

    public ActiveCrystalAttunementRecipe(AttuneCrystalRecipe recipe, CompoundNBT nbt) {
        super(recipe);
        this.readFromNBT(nbt);
    }

    @Override
    public boolean matches(TileAttunementAltar altar) {
        if (!super.matches(altar)) {
            return false;
        }
        Entity entity = altar.func_145831_w().func_73045_a(this.entityId);
        return entity != null && entity.func_70089_S() && entity instanceof ItemEntity && this.constellation.equals(altar.getActiveConstellation()) && AttuneCrystalRecipe.isApplicableCrystal((ItemEntity)entity, altar.getActiveConstellation());
    }

    @Override
    public void startCrafting(TileAttunementAltar altar) {
    }

    @Override
    public void stopCrafting(TileAttunementAltar altar) {
    }

    @Override
    public void finishRecipe(TileAttunementAltar altar) {
        ItemEntity crystal = this.getEntity(altar.func_145831_w());
        if (crystal != null) {
            ItemStack stack = crystal.func_92059_d();
            if (!(stack.func_77973_b() instanceof ConstellationItem) && stack.func_77973_b() instanceof ItemCrystalBase) {
                CompoundNBT tag = stack.func_77978_p();
                stack = new ItemStack((IItemProvider)((ItemCrystalBase)stack.func_77973_b()).getTunedItemVariant(), stack.func_190916_E());
                stack.func_77982_d(tag);
            }
            if (stack.func_77973_b() instanceof ConstellationItem) {
                IWeakConstellation attuned = ((ConstellationItem)stack.func_77973_b()).getAttunedConstellation(stack);
                IMinorConstellation trait = ((ConstellationItem)stack.func_77973_b()).getTraitConstellation(stack);
                if (attuned == null) {
                    if (altar.getActiveConstellation() instanceof IWeakConstellation) {
                        ((ConstellationItem)stack.func_77973_b()).setAttunedConstellation(stack, (IWeakConstellation)altar.getActiveConstellation());
                    }
                } else if (trait == null && altar.getActiveConstellation() instanceof IMinorConstellation) {
                    ((ConstellationItem)stack.func_77973_b()).setTraitConstellation(stack, (IMinorConstellation)altar.getActiveConstellation());
                }
                crystal.func_92058_a(stack);
            }
        }
    }

    @Override
    public void doTick(LogicalSide side, TileAttunementAltar altar) {
        ItemEntity crystal = this.getEntity(altar.func_145831_w());
        if (crystal == null) {
            return;
        }
        Vector3 crystalHoverPos = new Vector3(altar).add(0.5, 1.4, 0.5);
        crystal.func_70107_b(crystalHoverPos.getX(), crystalHoverPos.getY(), crystalHoverPos.getZ());
        crystal.field_70169_q = crystalHoverPos.getX();
        crystal.field_70167_r = crystalHoverPos.getY();
        crystal.field_70166_s = crystalHoverPos.getZ();
        crystal.func_213293_j(0.0, 0.0, 0.0);
        if (side.isClient()) {
            this.doClientTick(altar);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientTick(TileAttunementAltar altar) {
        FXFacingParticle p;
        Vector3 at;
        int i;
        Predicate<PositionedLoopSound> activeTest = s -> !altar.canPlayConstellationActiveEffects() || altar.getActiveRecipe() != this;
        if (this.itemAttuneSound == null || ((FadeLoopSound)((Object)this.itemAttuneSound)).hasStoppedPlaying()) {
            this.itemAttuneSound = ((FadeLoopSound)((Object)SoundHelper.playSoundLoopFadeInClient(SoundsAS.ATTUNEMENT_ATLAR_ITEM_LOOP, new Vector3(altar).add(0.5, 1.0, 0.5), 1.0f, 1.0f, false, activeTest).setFadeInTicks(20.0f))).setFadeOutTicks(20.0f);
        }
        if (this.getTick() == 0) {
            SoundHelper.playSoundClientWorld(SoundsAS.ATTUNEMENT_ATLAR_ITEM_START, altar.func_174877_v(), 1.0f, 1.0f);
        }
        if (this.getTick() >= 80 && (this.attunementFlare == null || ((EntityComplexFX)this.attunementFlare).isRemoved())) {
            this.attunementFlare = ((EntityComplexFX)((FXFacingSprite)EffectHelper.of(EffectTemplatesAS.FACING_SPRITE).spawn(new Vector3(altar).add(0.5, 1.75, 0.5))).setSprite(SpritesAS.SPR_ATTUNEMENT_FLARE).setScaleMultiplier(2.5f)).refresh(fx -> altar.canPlayConstellationActiveEffects() && altar.getActiveRecipe() == this);
        }
        Vector3 altarPos = new Vector3(altar).add(0.5, 0.0, 0.5);
        if (this.innerOrbital1 == null) {
            this.innerOrbital1 = EffectHelper.spawnSource(new FXOrbitalCrystalAttunement(altarPos.clone(), altarPos.clone().addY(1.75), this.constellation)).setOrbitRadius(3.0).setBranches(4).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setTicksPerRotation(200).refresh(RefreshFunction.tileExistsAnd(altar, (tile, effect) -> tile.canPlayConstellationActiveEffects() && tile.getActiveRecipe() == this));
        }
        VFXColorFunction beamColor = VFXColorFunction.constant(ColorsAS.DEFAULT_GENERIC_PARTICLE);
        if (this.getTick() >= 80 && this.getTick() % 40 == 0) {
            for (BlockPos pos : altar.getConstellationPositions(this.constellation)) {
                Vector3 from = new Vector3((Vec3i)pos).add(0.5, 0.0, 0.5);
                MiscUtils.applyRandomOffset(from, this.rand, 0.1f);
                ((EntityComplexFX)((EntityVisualFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(from)).setup(from.clone().addY(6.0), 1.2, 1.2).setAlphaMultiplier(0.8f)).color(beamColor)).setMaxAge(60);
            }
        }
        float total = 500.0f;
        float percCycle = (float)((double)((float)this.getTick() % total / total * 2.0f) * Math.PI);
        int parts = this.getTick() % 50 == 0 ? 180 : 6;
        Vector3 center = new Vector3(altar).add(0.5, 0.1, 0.5);
        float angleSwirl = 120.0f;
        float dst = 4.5f;
        for (int i2 = 0; i2 < parts; ++i2) {
            Vector3 v = Vector3.RotAxis.X_AXIS.clone();
            float originalAngle = (float)i2 / (float)parts * 360.0f;
            double angle = originalAngle + MathHelper.func_76126_a((float)percCycle) * angleSwirl;
            v.rotate(-Math.toRadians(angle), Vector3.RotAxis.Y_AXIS).normalize().multiply(dst);
            Vector3 pos = center.clone();
            Vector3 mot = center.clone().subtract(pos.clone().add(v)).normalize().multiply(0.14);
            int age = 20 + this.rand.nextInt(30);
            float size = 0.2f + this.rand.nextFloat() * 0.7f;
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).setScaleMultiplier(size)).setMotion(mot)).color(VFXColorFunction.WHITE)).setMaxAge(age);
            if (this.rand.nextInt(6) != 0) continue;
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).setScaleMultiplier(size * 1.4f)).setMotion(mot)).color(VFXColorFunction.constant(this.constellation.getConstellationColor()))).setGravityStrength(-4.0E-4f + this.rand.nextFloat() * -1.5E-4f)).setMaxAge(age + 30);
        }
        double scale = 7.0;
        double edgeScale = scale * 2.0 + 1.0;
        for (i = 0; i < 7; ++i) {
            Vector3 offset = new Vector3(altar).add(-scale, 0.1, -scale);
            if (this.rand.nextBoolean()) {
                offset.add(edgeScale * (double)(this.rand.nextBoolean() ? 1 : 0), 0.0, (double)this.rand.nextFloat() * edgeScale);
            } else {
                offset.add((double)this.rand.nextFloat() * edgeScale, 0.0, edgeScale * (double)(this.rand.nextBoolean() ? 1 : 0));
            }
            FXFacingParticle particle = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).alpha(VFXAlphaFunction.FADE_OUT)).setGravityStrength(-2.0E-4f + this.rand.nextFloat() * -1.0E-4f)).setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.15f)).color(VFXColorFunction.WHITE)).setMaxAge(40 + this.rand.nextInt(10));
            if (!this.rand.nextBoolean()) continue;
            particle.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
        }
        if (this.getTick() >= 200) {
            for (i = 0; i < 3; ++i) {
                at = new Vector3(altar).add(0.5, 0.0, 0.5);
                at.addX(this.rand.nextFloat() * 7.0f * (float)(this.rand.nextBoolean() ? 1 : -1));
                at.addZ(this.rand.nextFloat() * 7.0f * (float)(this.rand.nextBoolean() ? 1 : -1));
                p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setAlphaMultiplier(0.75f)).alpha(VFXAlphaFunction.FADE_OUT)).setGravityStrength(-0.001f + this.rand.nextFloat() * -5.0E-4f)).color(VFXColorFunction.WHITE)).setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.1f)).setMaxAge(20 + this.rand.nextInt(10));
                if (this.rand.nextBoolean()) {
                    p.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
                }
                if (this.getTick() < 400) continue;
                p.setScaleMultiplier(0.3f + this.rand.nextFloat() * 0.15f);
            }
        }
        if (this.getTick() >= 460 && this.getTick() % 5 == 0) {
            Vector3 from = new Vector3(altar).add(0.5, 0.0, 0.5);
            MiscUtils.applyRandomOffset(from, this.rand, 0.25f);
            ((EntityComplexFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(from)).setup(from.clone().addY(8.0), 2.4, 2.0).setAlphaMultiplier(0.8f)).setMaxAge(30 + this.rand.nextInt(15));
        }
        if (this.getTick() >= 490) {
            for (int i3 = 0; i3 < 25; ++i3) {
                at = new Vector3(altar).add(0.5, 0.0, 0.5).addY((double)this.rand.nextFloat() * 0.5 + (double)this.rand.nextFloat() * 0.5);
                p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).color(VFXColorFunction.WHITE)).setMotion(Vector3.random().setY(0).normalize().multiply(0.025 + (double)this.rand.nextFloat() * 0.075))).setAlphaMultiplier(0.75f)).setScaleMultiplier(0.25f + this.rand.nextFloat() * 0.15f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(60 + this.rand.nextInt(40));
                if (!this.rand.nextBoolean()) continue;
                p.color(VFXColorFunction.constant(this.constellation.getConstellationColor()));
            }
        }
    }

    @Override
    public boolean isFinished(TileAttunementAltar altar) {
        return this.getTick() >= 500;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void stopEffects(TileAttunementAltar altar) {
        if (this.isFinished(altar)) {
            SoundHelper.playSoundClientWorld(SoundsAS.ATTUNEMENT_ATLAR_ITEM_FINISH, altar.func_174877_v().func_177984_a(), 1.0f, 1.0f);
        }
        if (this.innerOrbital1 != null) {
            ((EntityComplexFX)this.innerOrbital1).requestRemoval();
        }
        if (this.attunementFlare != null) {
            ((EntityComplexFX)this.attunementFlare).requestRemoval();
        }
    }

    @Nullable
    private ItemEntity getEntity(World world) {
        Entity entity = world.func_73045_a(this.entityId);
        if (entity != null && entity.func_70089_S() && entity instanceof ItemEntity) {
            return (ItemEntity)entity;
        }
        return null;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("constellation", this.constellation.getRegistryName().toString());
        nbt.func_74768_a("entityId", this.entityId);
    }

    @Override
    protected void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.constellation = (IConstellation)RegistriesAS.REGISTRY_CONSTELLATIONS.getValue(new ResourceLocation(nbt.func_74779_i("constellation")));
        this.entityId = nbt.func_74762_e("entityId");
    }
}

